import { fileURLToPath } from "node:url";
import { defineConfig } from "vite";
import tailwindcss from "@tailwindcss/vite";
import laravel from "laravel-vite-plugin";
import path from "path";

export default defineConfig({
    plugins: [
        laravel({
            input: [
                "resources/admin/js/app.js",
                "resources/admin/js/tinymce.js",
                "resources/admin/js/categories-select.js",
                "resources/admin/sass/app.scss",
                "resources/admin/template/vendor/css/pages/page-auth.css",
                "resources/front/js/script.js",
                "resources/front/sass/styles.scss",
            ],
            refresh: true,
        }),
        tailwindcss(),
    ],
    resolve: {
        alias: {
            "~bootstrap": path.resolve(__dirname, "node_modules/bootstrap"),
            "@admin-template": fileURLToPath(
                new URL("./resources/admin/template", import.meta.url)
            ),
            "@js-vendor": fileURLToPath(
                new URL("./resources/admin/js/vendor", import.meta.url)
            ),
            "@": fileURLToPath(
                new URL("./resources/front/assets", import.meta.url)
            ),
            "~": fileURLToPath(new URL("./node_modules", import.meta.url)),
        },
    },
});
