<footer class="pb-10 md:pb-5">
    <div class="container">
        <?php if(isset($domain->logo)): ?>
            <img class="mb-[3.5rem] w-20 sm:place-self-center" src="<?php echo e(asset('storage/' . $domain->logo)); ?>" alt="logo">
        <?php endif; ?>

        <div class="grid grid-cols-2 gap-11 lg:grid-cols-1 lg:gap-5">
            <div class="">
                <p class="font-bold text-gray">Контакти</p>
                <hr class="mb-3 text-grey bg-grey border-t-gray border-[1px]">
                <div class="grid grid-cols-2 gap-7 font-medium md:grid-cols-1 md:gap-4">
                    <div class="flex flex-col gap-1">
                        <ul class="list-none">
                            <li class="mb-1">ЦЕНТРАЛЕН ОФИС</li>
                            <li class="mb-1">България, София 1700</li>
                            <li class="mb-1">Бизнес център Туинс</li>
                            <li class="mb-1">ул. Н. Габровски 79</li>
                            <li class="mb-1"><a href="#">Офиси в страната</a></li>
                            <li><a href="#">Service Desk</a></li>
                        </ul>
                        <div class="flex gap-2 mt-7 md:hidden ">
                            <?php if(isset($domain->facebook)): ?>
                                <a class="no-underline animation-scale-up" href="<?php echo e($domain->facebook); ?>">
                                    <i class="icon-facebook">
                                        <span class="path1"></span>
                                        <span class="path2"></span>
                                    </i>
                                </a>
                            <?php endif; ?>
                            <?php if(isset($domain->instagram)): ?>
                                <a class="no-underline animation-scale-up" href="<?php echo e($domain->instagram); ?>">
                                    <i class="icon-instagram">
                                        <span class="path1"></span>
                                        <span class="path2"></span>
                                        <span class="path3"></span>
                                        <span class="path4"></span>
                                    </i>
                                </a>
                            <?php endif; ?>
                            <?php if(isset($domain->linkedin)): ?>
                                <a class="no-underline animation-scale-up" href="<?php echo e($domain->linkedin); ?>">
                                    <i class="icon-linkedin">
                                        <span class="path1"></span>
                                        <span class="path2"></span>
                                    </i>
                                </a>
                            <?php endif; ?>
                            <?php if(isset($domain->youtube)): ?>
                                <a class="no-underline animation-scale-up" href="<?php echo e($domain->youtube); ?>">
                                    <i class="icon-youtube">
                                        <span class="path1"></span>
                                        <span class="path2"></span>
                                        <span class="path3"></span>
                                        <span class="path4"></span>
                                    </i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <ul class="list-none">
                            <li class="mb-1">
                                тел.: <a class="no-underline" href="tel:029604200">02/ 960 42 00</a>
                            </li>
                            <li class="mb-1">
                                моб.: <a class="no-underline" href="tel:0888 101 001 ">0888 101 001 </a>
                            </li>
                            <li class="mb-1">
                                Сервизен център: <a class="no-underline" href="tel:029604200">0700 10 887</a>
                            </li>
                            <li class="mb-1">
                                <a class="no-underline" href="mailto:office@paraflow.bg">office@paraflow.bg</a>
                            </li>
                            <li class="mb-1">
                                <a class="no-underline" href="mailto:sales@paraflow.bg">sales@paraflow.bg</a>
                            </li>
                            <li class=""><a href="#">Форма за запитване</a></li>

                        </ul>
                    </div>
                </div>
            </div>
            <div class="">
                <div class="group flex justify-between" data-show-more>
                    <p class="font-bold text-gray">Бързи бръзки</p>
                    <button class=" btn btn-icon-only md-min:hidden duration-0">
                        <i class="block icon-chevron-down text-black text-[3rem] group-[.isActive]:rotate-180"></i>
                    </button>
                </div>
                <hr class="mb-3 text-grey bg-grey border-t-gray border-[1px]">
                <div class="grid grid-cols-2 gap-7 font-medium md:grid-cols-1 md:gap-4 md:hidden" data-show-content>
                    <?php
                        $numberOfItems = $fastLinksMenu->menuItems->count();
                        $leftColumn = $fastLinksMenu->menuItems->take(ceil($numberOfItems / 2));
                        $rightColumn = $fastLinksMenu->menuItems->skip(ceil($numberOfItems / 2));
                    ?>
                    <div class="flex flex-col gap-1">
                        <ul class="list-none">
                            <?php $__currentLoopData = $leftColumn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="mb-1">
                                    <a class="no-underline animation-underline" href="<?php echo e(route('pages.show', $menuItem->link)); ?>"><?php echo e($menuItem->title); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="flex flex-col gap-1">
                        <ul class="list-none">
                            <?php $__currentLoopData = $rightColumn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="mb-1">
                                    <a class="no-underline animation-underline" href="<?php echo e(route('pages.show', $menuItem->link)); ?>"><?php echo e($menuItem->title); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="flex gap-2 mt-3 md-min:hidden">
                    <?php if(isset($domain->facebook)): ?>
                        <a class="no-underline animation-scale-up" href="<?php echo e($domain->facebook); ?>">
                            <i class="icon-facebook">
                                <span class="path1"></span>
                                <span class="path2"></span>
                            </i>
                        </a>
                    <?php endif; ?>
                    <?php if(isset($domain->instagram)): ?>
                        <a class="no-underline animation-scale-up" href="<?php echo e($domain->instagram); ?>">
                            <i class="icon-instagram">
                                <span class="path1"></span>
                                <span class="path2"></span>
                                <span class="path3"></span>
                                <span class="path4"></span>
                            </i>
                        </a>
                    <?php endif; ?>
                    <?php if(isset($domain->linkedin)): ?>
                        <a class="no-underline animation-scale-up" href="<?php echo e($domain->linkedin); ?>">
                            <i class="icon-linkedin">
                                <span class="path1"></span>
                                <span class="path2"></span>
                            </i>
                        </a>
                    <?php endif; ?>
                    <?php if(isset($domain->youtube)): ?>
                        <a class="no-underline animation-scale-up" href="<?php echo e($domain->youtube); ?>">
                            <i class="icon-youtube">
                                <span class="path1"></span>
                                <span class="path2"></span>
                                <span class="path3"></span>
                                <span class="path4"></span>
                            </i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <p class="mt-5 mb-0 text-[1.8rem] text-gray md:mt-3">Всички публикувани текстове и изображения са под закрила
            на "Закон за авторското право и сродните му права". Използването на част или цялото съдържание на сайта без
            разрешение е забранено. <span class="text-paragraph">© 2025 Paraflow Communications Ltd.</span></p>

    </div>
</footer>
<?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/partials/front/_footer.blade.php ENDPATH**/ ?>