<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed">

<head>
    <meta charset="UTF-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Admin Panel</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/admin/sass/app.scss']); ?>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <?php echo $__env->make('partials.admin.layout._menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Layout container -->
            <div class="layout-page">

                <?php echo e($horizontalNav ?? null); ?>


                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-xxl flex-grow-1 container-p-y">
                        <?php echo e($slot); ?>

                    </div>
                    <!-- / Content -->

                    <?php echo $__env->make('partials.admin.layout._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>

        <?php if(session()->has('success')): ?>
        <div class="position-fixed bottom-0 end-0 me-4 alert alert-site alert-primary" role="alert">
            <?php echo e(session()->get('success')); ?>

        </div>
        <?php endif; ?>

        <?php if(session()->has('error')): ?>
        <div class="position-fixed bottom-0 end-0 me-4 alert alert-site alert-danger" role="alert">
            <?php echo e(session()->get('error')); ?>

        </div>
        <?php endif; ?>
    </div>
    <!-- / Layout wrapper -->

    <div id="loader-main-bg">
        <div id="loader">
            <div class="spinner-border text-success" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/admin/js/app.js']); ?>

    <?php if(str()->contains(Route::currentRouteName(), ['.edit', '.create'])): ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/admin/js/tinymce.js']); ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/admin/js/categories-select.js']); ?>
    <?php endif; ?>
</body>

</html><?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/layouts/admin.blade.php ENDPATH**/ ?>