<section class="section-spacing container">
    <?php if(isset($section->title) && $section->title !== 'no_title'): ?>
        <h2 class="mb-3 text-[5.6rem] md:text-[4rem]"><?php echo e($section->title); ?></h2>
    <?php endif; ?>

    <?php
        $favoriteItems = \App\Models\Page::where('page_type_id', $section->page_type_id)->where('is_favorite', true)->latest()->limit($section->number_items)->get();
    ?>

    <div class="grid grid-cols-3 gap-[1.6rem] lg:grid-cols-1">
        <?php if($section->sectionElements->isNotEmpty()): ?>
            <?php $__currentLoopData = $section->sectionElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($element->sectElType->type == 'card_full_width_item'): ?>
                    <div class="relative flex flex-col gap-[3.2rem] rounded-xl bg-[#FEFEFE] md:gap-[3.2rem]">
                        <a class="link-absolute-full" href="<?php echo e($element->link); ?>"></a>
                        <img class="flex-[0_0_auto] object-cover rounded-t-lg h-[40rem] xl:h-[35vw] md:h-[60vw]"
                            src="<?php echo e(asset('storage/' . $element->image)); ?>"
                            alt="<?php echo e(isset($element->title) ? $element->title : 'Card Image' . $key + 1); ?>"
                        >
                        <div class="flex-[1_1_100%] flex flex-col gap-[3.2rem] md:gap-[1.6rem]">
                            <?php if($element->title): ?>
                                <h3 class="m-0 text-[2.4rem] font-bold line-clamp-2 px-[1.6rem] md:line-clamp-3">
                                    <?php echo e($element->title); ?>

                                </h3>
                            <?php endif; ?>

                            <div class="m-0 text-[2rem] text-[#677C8B] min-h-[6.0rem] line-clamp-2 md:line-clamp-4 px-[1.6rem]">
                                <p><?php echo e($element->description); ?></p>
                            </div>

                            <a class="btn btn-primary btn-icon mb-[3.2rem] mx-[1.6rem] place-self-start" href="<?php echo e($element->link); ?>">
                                <span><?php echo e($element->link_text); ?></span>
                                <i class="icon-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php elseif($favoriteItems->isNotEmpty()): ?>
            <?php $__currentLoopData = $favoriteItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="relative flex flex-col gap-[3.2rem] rounded-xl bg-[#FEFEFE] md:gap-[3.2rem]">
                    <a class="link-absolute-full" href="<?php echo e(route('pages.show', $item->slug)); ?>"></a>
                    <img class="flex-[0_0_auto] object-cover rounded-t-lg h-[40rem] xl:h-[35vw] md:h-[60vw]"
                        src="<?php echo e(asset('storage/' . $item->cover_image)); ?>"
                        alt="<?php echo e(isset($item->title) ? $item->title : 'Card Image' . $key + 1); ?>"
                    >
                    <div class="flex-[1_1_100%] flex flex-col gap-[3.2rem] md:gap-[1.6rem]">
                        <?php if($item->title): ?>
                            <h3 class="m-0 text-[2.4rem] font-bold line-clamp-2 px-[1.6rem] md:line-clamp-3">
                                <?php echo e($item->title); ?>

                            </h3>
                        <?php endif; ?>

                        <div class="m-0 text-[2rem] text-[#677C8B] min-h-[6.0rem] line-clamp-2 md:line-clamp-4 px-[1.6rem]">
                            <p><?php echo e($item->description); ?></p>
                        </div>

                        <a class="btn btn-primary btn-icon mb-[3.2rem] mx-[1.6rem] place-self-start" href="<?php echo e(route('pages.show', $item->slug)); ?>">
                            <span><?php echo e(__('Learn more')); ?></span>
                            <i class="icon-arrow-right"></i>
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>
    <?php if($section->button_text): ?>
        <div class="w-full flex justify-center mt-[3.2rem] md:mt-[1.6rem]">
            <a class="btn btn-white md:w-full" href="<?php echo e($section->button_link); ?>">
                <span><?php echo e($section->button_text); ?></span>
            </a>
        </div>
    <?php endif; ?>
</section>
<?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/front/sections/cards_full_width.blade.php ENDPATH**/ ?>