<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
    <div class="app-brand">
        <a href="<?php echo e(route('admin.home')); ?>" class="app-brand-link">
            <span class="app-brand-logo">
                <img src="<?php echo e(asset('storage/admin/images/kipo_logo_engine.png')); ?>" height="64" alt="Kipo Engine logo">
            </span>
        </a>

        <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
            <i class="bx bx-chevron-left bx-sm align-middle"></i>
        </a>
    </div>

    <div class="menu-inner-shadow"></div>

    <ul class="menu-inner py-1">
        <li class="menu-item <?php if(Route::is('admin.home')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.home')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-home-circle"></i>
                <div data-i18n="Analytics"><?php echo e(admin_trans('dashboard')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(Route::is('admin.pages.*')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.pages.index')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-file-html"></i>
                <div data-i18n="Pages"><?php echo e(admin_trans('headings.pages')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(Route::is('admin.products.*')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.products.index')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-keyboard"></i>
                <div data-i18n="Products"><?php echo e(admin_trans('headings.products')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(Route::is('admin.projects.*')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.projects.index')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-chart"></i>
                <div data-i18n="Projects"><?php echo e(admin_trans('headings.projects')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(Route::is('admin.solutions.*')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.solutions.index')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-server"></i>
                <div data-i18n="Solutions"><?php echo e(admin_trans('headings.solutions')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(Route::is('admin.news.*')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.news.index')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-news"></i>
                <div data-i18n="News"><?php echo e(admin_trans('headings.news')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(
            Route::is('admin.clients.*')
            or Route::is('admin.businesses.*')
            or Route::is('admin.admins.*')
            ): ?> active open <?php endif; ?>">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bxs-user"></i>
                <div data-i18n="Users"><?php echo e(admin_trans('headings.users')); ?></div>
            </a>

            <ul class="menu-sub">
                <li class="menu-item <?php if(Route::is('admin.clients.*')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.clients.index')); ?>" class="menu-link">
                        <div data-i18n="Clients"><?php echo e(admin_trans('headings.clients')); ?></div>
                    </a>
                </li>

                <li class="menu-item <?php if(Route::is('admin.businesses.*')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.businesses.index')); ?>" class="menu-link">
                        <div data-i18n="Businesses"><?php echo e(admin_trans('headings.businesses')); ?></div>
                    </a>
                </li>

                <li class="menu-item <?php if(Route::is('admin.admins.*')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.admins.index')); ?>" class="menu-link">
                        <div data-i18n="Admins"><?php echo e(admin_trans('headings.administrators')); ?></div>
                    </a>
                </li>
            </ul>
        </li>

        <li class="menu-item <?php if(Route::is('elfinder.index')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('elfinder.index')); ?>" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-file-find"></i>
                <div data-i18n="Analytics"><?php echo e(admin_trans('file_manager')); ?></div>
            </a>
        </li>

        <li class="menu-item <?php if(Route::is('admin.settings.*')): ?> active open <?php endif; ?>">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bxs-cog"></i>
                <div data-i18n="Settings"><?php echo e(admin_trans('headings.settings')); ?></div>
            </a>

            <ul class="menu-sub">
                <li class="menu-item <?php if(Route::is('admin.settings.domains.*')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.settings.domains.index')); ?>" class="menu-link">
                        <div data-i18n="Domains"><?php echo e(admin_trans('headings.domains')); ?></div>
                    </a>
                </li>
            </ul>

            <ul class="menu-sub">
                <li class="menu-item <?php if(Route::is('admin.settings.menus.*')): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.settings.menus.index')); ?>" class="menu-link">
                        <div data-i18n="Menus"><?php echo e(admin_trans('headings.menus')); ?></div>
                    </a>
                </li>
            </ul>
        </li>

    </ul>

    <?php if(isset($domain)): ?>
        <div class="clientLogo">
            <?php
                if (str()->startsWith($domain->domain, 'http')) {
                    $url = $domain->domain;
                } else {
                    $url = 'https://' . $domain->domain;
                }
            ?>
            <a href="<?php echo e($url); ?>" target="_blank">
                <?php if(isset($domain->logo)): ?>
                    <img src="<?php echo e(asset('storage/' . $domain->logo)); ?>" width="100%" alt="Kipo Engine logo">
                <?php else: ?>
                    <img src="<?php echo e(asset('storage/admin/images/kipo_logo_engine.png')); ?>" width="100%" alt="Kipo Engine logo">
                <?php endif; ?>
                <span><?php echo e($domain->domain); ?> <i class="bx bx-link-external"></i></span>
            </a>
        </div>
    <?php endif; ?>
</aside><?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/partials/admin/layout/_menu.blade.php ENDPATH**/ ?>