<!DOCTYPE html>
<html lang="<?php echo e(config('app.locale') === 'bg' ? 'bg' : 'en'); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/images/favicon.png')); ?>">
    <?php echo e($meta); ?>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/front/sass/styles.scss']); ?>
</head>


<body class="<?php echo e($bodyClass); ?>">
    <?php echo e($header); ?>


    <main>
        <?php echo e($slot); ?>

    </main>

    <?php echo e($footer); ?>


    <button
        data-scroll-up
        class="btn btn-primary btn-icon-only hidden fixed bottom-13 right-13 z-[10]
                !w-[5.6rem] !h-[5.6rem] !rounded-[50%]
                desktop:bottom-6 desktop:right-6
                md:bottom-3 md:right-3"
    >
        <i class="icon-chevron-up text-white"></i>
    </button>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/front/js/script.js']); ?>
</body>

</html>
<?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/layouts/front.blade.php ENDPATH**/ ?>