<section class="section-spacing container" data-tab-content>
  <?php if($section->title): ?>
    <h2 class="mb-3 text-[5.6rem] md:text-[4rem]"><?php echo e($section->title); ?></h2>
  <?php endif; ?>

  <?php
    $industryTabs = [];
    $industryContent = [];
    foreach ($section->children as $child) {
        foreach ($child->children as $child) {
            if ($child->sectionType->type == 'industry_tab') {
                $industryTabs[] = $child;
            }

            if ($child->sectionType->type == 'industry_content') {
                $industryContent[] = $child;
            }
      }
    }
  ?>

    <?php if($industryTabs): ?>
    <div class="grid grid-cols-[50rem_1fr] gap-[3.2rem] xl:grid-cols-1">
        <div class="flex flex-col gap-[1.6rem] xl:grid grid-cols-2 gap-2 lg:grid-cols-1">
            <?php $__currentLoopData = $industryTabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $key = $key + 1;
                ?>
                <a
                    class="c-industry-tab flex items-center gap-[2rem] p-[2.4rem_4rem] rounded-md bg-white-2 no-underline overflow-hidden md:p-[1.6rem_4rem] <?php echo e($key == 1 ? 'active' : ''); ?>"
                    data-tab="<?php echo e($key); ?>"
                >
                    <img class="w-[4.8rem]"
                        src="<?php echo e(asset('storage/' . $element->image)); ?>"
                        alt="<?php echo e($element->title); ?>">
                    <p class="m-0"><?php echo e($element->title); ?></p>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <?php if($industryContent): ?>
        <div class="w-full grid grid-cols-1">
            <?php $__currentLoopData = $industryContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $key = $key + 1;
                    $industryContentList = $content->children->where('sectionType.type', 'industry_content_list');
                ?>
                <div
                    id="popup-tab-content-<?php echo e($key); ?>"
                    class="c-industry-content col-start-1 col-end-1 row-start-1 row-end-1 xl:hidden self-start w-full p-6 rounded-xl bg-white-2 desktop:p-4 <?php echo e($key == 1 ? 'active' : ''); ?>"
                    data-content="<?php echo e($key); ?>"
                >
                    <div class="flex justify-between items-start">
                        <h3 class="mb-6 f desktop:mb-4"><?php echo e($content->title); ?></h3>
                        <button class="btn btn-icon-only popup-close xl-min:hidden">
                            <i class="icon-close"></i>
                        </button>
                    </div>
                    <div class="content columns-3 gap-6 desktop:columns-2 desktop:gap-4 xl:columns-3 lg:columns-2 md:columns-1 md:gap-2">
                        <?php $__currentLoopData = $industryContentList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="flex justify-between items-start mb-[2.4rem] no-underline" href="<?php echo e($list->link); ?>">
                                <span class="text-primary text-[1.6rem] font-bold"><?php echo e($list->title); ?></span>
                                <i class="flex-[0_0_auto] icon-chevron-right text-primary text-[2.4rem]"></i>
                            </a>
                            <ul class="list-none mb-[2.4rem]">
                                <?php $__currentLoopData = $list->sectionElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($element->sectElType->type == 'industry_content_list_item'): ?>
                                        <li class="mb-[2.4rem]"><?php echo e($element->title); ?></li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
  </div>
</section>
<?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/front/sections/industries.blade.php ENDPATH**/ ?>