<?php
    foreach ($mainMenu->menuItems as $menuItem) {
        if ($menuItem->children->contains(fn ($child) => "{$urlParentSlug}/{$slug}" === $child->link)) {
            $menuItem->isActiveParent = true;
        }
    }
?>

<nav class="nav">
    <ul class="list-none <?php echo e(isset($searchIsActive) && $searchIsActive ? 'lg-min:invisible' : ''); ?>">
        <?php $__currentLoopData = $mainMenu->menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($menuItem->isRoot()): ?>
                <?php
                    $isCurrentParent = isset($menuItem->isActiveParent) || $slug === $menuItem->link;
                ?>
                <?php if($menuItem->children->isNotEmpty()): ?>
                    <li data-dropdown class="dropdown <?php echo e($isCurrentParent ? 'isCurrent' : ''); ?>">
                        <a href="<?php echo e(route('pages.show', $menuItem->link)); ?>" data-solution-link data-anchor="<?php echo e($menuItem->link); ?>">
                            <span><?php echo e($menuItem->title); ?></span>
                            <i class="icon-chevron-down text-[1.8rem] lg-min:hidden"></i>
                        </a>
                        <ul data-dropdown-content class="dropdown-content list-none">
                            <?php $__currentLoopData = $menuItem->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="<?php echo e("{$urlParentSlug}/{$slug}" === $child->link ? 'isCurrent' : ''); ?>"><a href="<?php echo e(route('pages.show', $child->link)); ?>"><?php echo e($child->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                <?php else: ?>
                    <li class="<?php echo e($slug === $menuItem->link ? 'isCurrent' : ''); ?>"><a href="<?php echo e(route('pages.show', $menuItem->link)); ?>"><span><?php echo e($menuItem->title); ?></span></a></li>
                <?php endif; ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>

    <form
        data-search-content
        action="<?php echo e(route('pages.search')); ?>" method="POST"
        class="search-content <?php echo e(isset($searchIsActive) && $searchIsActive ? 'isActive' : ''); ?>"
    >
        <?php echo csrf_field(); ?>

        <input name="search" type="text" id="search" value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(__('Search in Paraflow')); ?>">
        <div class="flex gap-2">
            <button type="submit" class="btn btn-icon-only">
                <i class="icon-search text-[2.4rem] text-gray lg:text-black"></i>
            </button>
            <button data-search-close type="button" class="btn btn-icon-only">
                <i class="icon-close text-[2.2rem] text-gray"></i>
            </button>
        </div>
    </form>
</nav><?php /**PATH /Users/stoycho/business/kipo/sites/paraflow/resources/views/partials/front/_main-menu.blade.php ENDPATH**/ ?>