<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\PageController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\Admin\HomeController as AdminHomeController;
use App\Http\Controllers\Admin\MenuController as AdminMenuController;
use App\Http\Controllers\Admin\PageController as AdminPageController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\ProjectController as AdminProjectController;
use App\Http\Controllers\Admin\SolutionController as AdminSolutionController;
use App\Http\Controllers\Admin\NewsController as AdminNewsController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Admin\AdminController as AdminAdminController;
use App\Http\Controllers\Admin\ImageController as AdminImageController;
use App\Http\Controllers\Admin\ClientController as AdminClientController;
use App\Http\Controllers\Admin\DomainController as AdminDomainController;
use App\Http\Controllers\Admin\SectionController as AdminSectionController;
use App\Http\Controllers\Admin\BusinessController as AdminBusinessController;
use App\Http\Controllers\Admin\MenuItemController as AdminMenuItemController;
use App\Http\Controllers\Admin\SectionElementController as AdminSectionElementController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::prefix('admin')
    ->name('admin.')
    ->namespace('\App\Http\Controllers\Admin')
    ->middleware(['auth', 'role:admin'])
    ->group(function () {
        Route::put('pages/sort', [AdminPageController::class, 'sort'])->name('pages.sort');
        Route::resource('pages', AdminPageController::class)->except('show');
        Route::patch('pages/delete-cover-image/{page}', [AdminPageController::class, 'deleteCoverImage'])->name('pages.delete-cover-image');
        Route::patch('pages/toggle-active/{page}', [AdminPageController::class, 'toggleActive'])->name('pages.toggle-active');
        Route::patch('pages/toggle-favorite/{page}', [AdminPageController::class, 'toggleFavorite'])->name('pages.toggle-favorite');

        Route::put('products/sort', [AdminProductController::class, 'sort'])->name('products.sort');
        Route::resource('products', AdminProductController::class)->except('show');
        Route::patch('products/delete-cover-image/{product}', [AdminProductController::class, 'deleteCoverImage'])->name('products.delete-cover-image');
        Route::patch('products/delete-secondary-image/{product}', [AdminProductController::class, 'deleteSecondaryImage'])->name('products.delete-secondary-image');
        Route::patch('products/toggle-active/{product}', [AdminProductController::class, 'toggleActive'])->name('products.toggle-active');
        Route::patch('products/toggle-favorite/{product}', [AdminProductController::class, 'toggleFavorite'])->name('products.toggle-favorite');

        Route::put('projects/sort', [AdminProjectController::class, 'sort'])->name('projects.sort');
        Route::resource('projects', AdminProjectController::class)->except('show');
        Route::patch('projects/delete-cover-image/{project}', [AdminProjectController::class, 'deleteCoverImage'])->name('projects.delete-cover-image');
        Route::patch('projects/delete-secondary-image/{project}', [AdminProjectController::class, 'deleteSecondaryImage'])->name('projects.delete-secondary-image');
        Route::patch('projects/toggle-active/{project}', [AdminProjectController::class, 'toggleActive'])->name('projects.toggle-active');
        Route::patch('projects/toggle-favorite/{project}', [AdminProjectController::class, 'toggleFavorite'])->name('projects.toggle-favorite');

        Route::put('solutions/sort', [AdminSolutionController::class, 'sort'])->name('solutions.sort');
        Route::resource('solutions', AdminSolutionController::class)->except('show');
        Route::patch('solutions/delete-cover-image/{solution}', [AdminSolutionController::class, 'deleteCoverImage'])->name('solutions.delete-cover-image');
        Route::patch('solutions/delete-secondary-image/{solution}', [AdminSolutionController::class, 'deleteSecondaryImage'])->name('solutions.delete-secondary-image');
        Route::patch('solutions/toggle-active/{solution}', [AdminSolutionController::class, 'toggleActive'])->name('solutions.toggle-active');
        Route::patch('solutions/toggle-favorite/{solution}', [AdminSolutionController::class, 'toggleFavorite'])->name('solutions.toggle-favorite');

        Route::put('news/sort', [AdminNewsController::class, 'sort'])->name('news.sort');
        Route::resource('news', AdminNewsController::class)->except('show');
        Route::patch('news/delete-cover-image/{news}', [AdminNewsController::class, 'deleteCoverImage'])->name('news.delete-cover-image');
        Route::patch('news/delete-secondary-image/{news}', [AdminNewsController::class, 'deleteSecondaryImage'])->name('news.delete-secondary-image');
        Route::patch('news/toggle-active/{news}', [AdminNewsController::class, 'toggleActive'])->name('news.toggle-active');
        Route::patch('news/toggle-favorite/{news}', [AdminNewsController::class, 'toggleFavorite'])->name('news.toggle-favorite');

        Route::put('sections/sort', [AdminSectionController::class, 'sort'])->name('sections.sort');
        Route::patch('sections/delete-cover-image/{section}', [AdminSectionController::class, 'deleteCoverImage'])->name('sections.delete-cover-image');
        Route::patch('sections/delete-image/{section}/{locale}/{imageType}', [AdminSectionController::class, 'deleteImage'])->name('sections.delete-image');
        Route::resource('sections', AdminSectionController::class)->except(['show', 'index']);
        Route::get('sections/select-type/{parentClass}/{parentId}', [AdminSectionController::class, 'selectType'])->name('sections.select-type');
        Route::post('sections/upload-image/{section}', [AdminSectionController::class, 'uploadImage'])->name('sections.upload-image');
        // Route::get('sections/create/{parentClass}/{parentId}/{type}', [AdminSectionController::class, 'create'])->name('sections.create');
        Route::patch('sections/toggle-active/{section}', [AdminSectionController::class, 'toggleActive'])->name('sections.toggle-active');
        // Route::patch('sections/update-type/{section}', [AdminSectionController::class, 'updateType'])->name('sections.update-type');

        Route::put('section-elements/sort', [AdminSectionElementController::class, 'sort'])->name('section-elements.sort');
        Route::patch('section-elements/delete-cover-image/{sectionElement}', [AdminSectionElementController::class, 'deleteCoverImage'])
            ->name('section-elements.delete-cover-image');
        Route::resource('section-elements', AdminSectionElementController::class)->except(['show', 'index']);
        // Route::get('section-elements/select-type/{section}', [AdminSectionElementController::class, 'selectType'])->name('section-elements.select-type');
        Route::post('section-elements/upload-image/{sectionElement}', [AdminSectionElementController::class, 'uploadImage'])->name('section-elements.upload-image');
        Route::patch('section-elements/delete-image/{sectionElement}/{imageType}/{locale}', [AdminSectionElementController::class, 'deleteImage'])
            ->name('section-elements.delete-image');

        Route::resource('images', AdminImageController::class)->only('update', 'destroy');
        Route::get('images/edit/{image}/{parentPath}/{parentId}', [AdminImageController::class, 'edit'])->name('images.edit');
        Route::get('images/get-order', [AdminImageController::class, 'getOrder'])->name('images.get-order');
        Route::post('images/change-order', [AdminImageController::class, 'changeOrder'])->name('images.change-order');

        Route::get('/users/profile-information/{user}', [AdminUserController::class, 'editOwnProfile'])->name('user.profile.edit');
        Route::get('/users/password/{user}', [AdminUserController::class, 'editOwnPassword'])->name('user.password.edit');
        Route::delete('/users/{user}', [AdminUserController::class, 'destroy'])->name('users.destroy');

        Route::resource('clients', AdminClientController::class)->except('show');
        Route::resource('businesses', AdminBusinessController::class)->except('show');
        Route::resource('admins', AdminAdminController::class)->except('show');

        Route::prefix('settings')->name('settings.')->group(function () {
            Route::resource('domains', AdminDomainController::class)->except('show');
            Route::patch('domains/delete-logo/{domain}/{logoType}', [AdminDomainController::class, 'deleteLogo'])->name('domains.delete-logo');

            Route::prefix('menus')->name('menus.')->group(function () {
                Route::put('sort', [AdminMenuController::class, 'sort'])->name('sort');
                Route::resource('/', AdminMenuController::class)->except('show')->parameters(['' => 'menu']);
                Route::patch('toggle-active/{menu}', [AdminMenuController::class, 'toggleActive'])->name('toggle-active');

                Route::put('menu-items/sort', [AdminMenuItemController::class, 'sort'])->name('menu-items.sort');
                Route::resource('menu-items', AdminMenuItemController::class)->except('index', 'show');
            });
        });

        Route::get('/', AdminHomeController::class)->name('home');
    });


Route::delete('/user/{user}', [AdminUserController::class, 'destroyOwnAcount'])->name('users.delete_acount');

Route::any('search', [PageController::class, 'search'])->name('pages.search');
Route::get('/', [PageController::class, 'home'])->name('home');
Route::get('{url}', [PageController::class, 'show'])->name('pages.show')->where('url', '.*');

Route::post('/language-switch', LanguageController::class)->name('language.switch');
