<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="utf-8">
        <title>elFinder 2.0</title>

        <!-- jQuery and jQuery UI (REQUIRED) -->
        <link rel="stylesheet" type="text/css" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.8.23/themes/smoothness/jquery-ui.css">
        <script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.0/jquery.min.js"></script>
        <script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js"></script>

        <!-- elFinder CSS (REQUIRED) -->
        <link rel="stylesheet" type="text/css" href="{{ asset($dir . '/css/elfinder.min.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset($dir . '/css/theme.css') }}">

        <!-- elFinder JS (REQUIRED) -->
        <script src="{{ asset($dir . '/js/elfinder.min.js') }}"></script>

        @if($locale)
            <!-- elFinder translation (OPTIONAL) -->
            <script src="{{ asset($dir . "/js/i18n/elfinder.$locale.js") }}"></script>
        @endif
        <!-- Include jQuery, jQuery UI, elFinder (REQUIRED) -->

        <style>
            .elfinder-cwd-wrapper .elfinder-cwd-view-icons .elfinder-cwd-file {
                width: 140px !important;
                height: 180px !important;
                margin: 6px !important;
                text-align: center;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
            }

            .elfinder-cwd-view-icons .elfinder-cwd-file-wrapper {
                height: 180px !important;
                width: 140px !important;
            }
            .elfinder-cwd-icon {
                width: 128px !important;
                height: 128px !important;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 4px auto;
            }

            .elfinder-cwd-icon img {
                max-width: 100% !important;
                max-height: 100% !important;
                object-fit: contain;
            }
            .elfinder-cwd-filename {
                display: block;
                max-width: 100%;
                height: 40px;
                overflow: hidden;
                text-overflow: ellipsis;
                white-space: nowrap;
            }

        </style>
        <script type="text/javascript">
            $().ready(function () {
                var elf = $('#elfinder').elfinder({
                    // set your elFinder options here
                    @if($locale)
                        lang: '{{ $locale ?? 'en' }}',
                    @endif
                    customData: {
                        _token: '{{ csrf_token() }}'
                    },
                    url: '{{ route("elfinder.connector") }}',  // connector URL
                    height: 500,
                    contextmenu: {
                        navbar: ['open', '|', 'mkdir', 'upload', '|', 'info'],
                        cwd: ['reload', 'back', '|', 'upload', 'mkdir', 'paste', '|', 'sort', '|', 'info'],
                        files: ['getfile', '|', 'open', 'quicklook', '|', 'download', '|', 'rename', 'edit', '|', 'copy', 'cut', 'paste', '|', 'rm', '|', 'info']
                    },
                    commandsOptions: {
                        edit: {
                            editors: [
                                // Allow editing only for text files
                                { mimes: ["text/plain", "text/html", "application/javascript"] }
                            ]
                        }
                    },
                    commands: ['open', 'reload', 'mkdir', 'upload', 'download', 'rm', 'rename', 'info'], // Define allowed commands
                    soundPath: '{{ asset($dir.'/sounds') }}',
                    dialog: {width: 900, modal: true, title: 'Select a file'},
                    resizable: false,
                    commandsOptions: {
                        getfile: {
                            multiple: true,
                            oncomplete: 'destroy'
                        }
                    },
                    themes: {
                        'mt-darkblue' : '{{ asset($dir.'/themes/material_theme/manifests/darkblue.json') }}',
                        'mt-gray'     : '{{ asset($dir.'/themes/material_theme/manifests/gray.json') }}',
                        'mt-light'    : '{{ asset($dir.'/themes/material_theme/manifests/light.json') }}'
                    },
                    theme : 'mt-light',
                    handlers: {
                        select: function (event, elfinderInstance) {
                            const file = event.data.selected.length
                                ? elfinderInstance.file(event.data.selected[0])
                                : null;

                            if (file && file.mime.startsWith('image/')) {
                                const url = elfinderInstance.url(file.hash);
                                $('#elfinder-preview').html(`<img src="${url}" style="max-width:100%; max-height:400px;" />`);
                            } else {
                                $('#elfinder-preview').empty();
                            }
                        }
                    },
                    getFileCallback: function (file) {
                        let paths = [];
                        let tmbs = [];
                        file.forEach(f => {
                            paths.push(f.path);
                            tmbs.push(f.tmb);
                        });
                        if ('{{ $input_id }}' === 'cover_image') {
                            window.parent.processSelectedCoverImg(paths, tmbs, '{{ $input_id  }}');
                        }
                        if ('{{ $input_id }}' === 'image') {
                            window.parent.processSelectedImage(paths, tmbs, '{{ $input_id  }}');
                        }
                        if ('{{ $input_id }}' === 'secondary_image') {
                            window.parent.processSelectedSecondaryImg(paths, tmbs, '{{ $input_id  }}');
                        }
                        if ('{{ $input_id }}' === 'gallery_image') {
                            window.parent.processSelectedGalleryImg(paths, tmbs, '{{ $input_id  }}');
                        }

                        parent.jQuery.colorbox.close();
                    }
                }).elfinder('instance');
            });
        </script>

    </head>
    <body>

        <!-- Element where elFinder will be created (REQUIRED) -->
        <div id="elfinder"></div>
        <div id="elfinder-preview" style="margin-top:20px; text-align:center; border-top:1px solid #ccc; padding-top:15px;"></div>

    </body>
</html>
