<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="utf-8">
        <title>File Manager</title>

        @vite(['resources/admin/sass/app.scss'])

        <!-- jQuery and jQuery UI (REQUIRED) -->
        <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.13.2/themes/smoothness/jquery-ui.css" />
        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
        <script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.13.2/jquery-ui.min.js"></script>

        <!-- elFinder CSS (REQUIRED) -->
        <link rel="stylesheet" type="text/css" href="{{ asset($dir.'/css/elfinder.min.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset($dir.'/css/theme.css') }}">
        {{-- <link rel="stylesheet" type="text/css" href="{{ asset($dir.'/themes/moono/css/theme.css') }}"> --}}


        <!-- elFinder JS (REQUIRED) -->
        <script src="{{ asset($dir.'/js/elfinder.min.js') }}"></script>

        @if($locale)
            <!-- elFinder translation (OPTIONAL) -->
            <script src="{{ asset($dir."/js/i18n/elfinder.$locale.js") }}"></script>
        @endif

        <style>
            .elfinder-cwd-wrapper .elfinder-cwd-view-icons .elfinder-cwd-file {
                width: 140px !important;
                height: 180px !important;
                margin: 6px !important;
                text-align: center;
                display: flex;
                flex-direction: column;
                justify-content: flex-start;
            }

            .elfinder-cwd-view-icons .elfinder-cwd-file-wrapper {
                height: 180px !important;
                width: 140px !important;
            }
            .elfinder-cwd-icon {
                width: 128px !important;
                height: 128px !important;
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 4px auto;
            }

            .elfinder-cwd-icon img {
                max-width: 100% !important;
                max-height: 100% !important;
                object-fit: contain;
            }
            .elfinder-cwd-filename {
                display: block;
                max-width: 100%;
                height: 40px;
                overflow: hidden;
                text-overflow: ellipsis;
                white-space: nowrap;
            }

        </style>
        <!-- elFinder initialization (REQUIRED) -->
        <script type="text/javascript" charset="utf-8">
            // Documentation for client options:
            // https://github.com/Studio-42/elFinder/wiki/Client-configuration-options
            $(document).ready(function () {
                $('#elfinder').elfinder({
                    lang: '{{ $locale ?? 'en' }}',
                    customData: {
                        _token: '{{ csrf_token() }}'
                    },
                    url: '{{ route("elfinder.connector") }}',
                    height: 600,
                    uiOptions: {
                        cwd: {
                            listView: false,
                            icons: true
                        }
                    },
                    handlers: {
                        select: function (event, elfinderInstance) {
                            const file = event.data.selected.length
                                ? elfinderInstance.file(event.data.selected[0])
                                : null;

                            if (file && file.mime.startsWith('image/')) {
                                const url = elfinderInstance.url(file.hash);
                                $('#elfinder-preview').html(`<img src="${url}" style="max-width:100%; max-height:400px;" />`);
                            } else {
                                $('#elfinder-preview').empty();
                            }
                        }
                    },
                    contextmenu: {
                        navbar: ['open', '|', 'mkdir', 'upload', '|', 'info'],
                        cwd: ['reload', 'back', '|', 'upload', 'mkdir', 'paste', '|', 'sort', '|', 'info'],
                        files: ['getfile', '|', 'open', 'quicklook', '|', 'download', '|', 'rename', 'edit', '|', 'copy', 'cut', 'paste', '|', 'rm', '|', 'info']
                    },
                    commandsOptions: {
                        edit: {
                            editors: [
                                { mimes: ["text/plain", "text/html", "application/javascript"] }
                            ]
                        }
                    },
                    commands: ['open', 'reload', 'mkdir', 'upload', 'download', 'rm', 'rename', 'info'],
                    soundPath: '{{ asset($dir."/sounds") }}',
                    themes : {
                                    'mt-darkblue' : '{{ asset($dir.'/themes/material_theme/manifests/darkblue.json') }}',
                                    'mt-gray'     : '{{ asset($dir.'/themes/material_theme/manifests/gray.json') }}',
                                    'mt-light'    : '{{ asset($dir.'/themes/material_theme/manifests/light.json') }}'
                                },
                    theme: 'mt-light',
                    loadTmbs: 5
                });

                $('.menu-toggle').click(function() {
                    $(this).next('.menu-sub').slideToggle();
                });
            });
        </script>
    </head>
    <body>
        <div class="layout-wrapper layout-content-navbar">
            <div class="layout-container">
                @include('partials.admin.layout._menu')
                <div class="layout-page">
                    <div class="content-wrapper">
                        <div class="container-xxl flex-grow-1 container-p-y">

                            <!-- Element where elFinder will be created (REQUIRED) -->
                            <div id="elfinder"></div>
                            <div id="elfinder-preview" style="margin-top:20px; text-align:center; border-top:1px solid #ccc; padding-top:15px;"></div>
                        </div>

                        @include('partials.admin.layout._footer')

                        <div class="content-backdrop fade"></div>
                    </div>
                </div>
            </div>
        </div>

    </body>
</html>
