@php
    foreach ($mainMenu->menuItems as $menuItem) {
        if ($menuItem->children->contains(fn ($child) => "{$urlParentSlug}/{$slug}" === $child->link)) {
            $menuItem->isActiveParent = true;
        }
    }
@endphp

<nav class="nav">
    <ul class="list-none {{ isset($searchIsActive) && $searchIsActive ? 'lg-min:invisible' : '' }}">
        @foreach ($mainMenu->menuItems as $menuItem)
            @if ($menuItem->isRoot())
                @php
                    $isCurrentParent = isset($menuItem->isActiveParent) || $slug === $menuItem->link;
                @endphp
                @if ($menuItem->children->isNotEmpty())
                    <li data-dropdown class="dropdown {{ $isCurrentParent ? 'isCurrent' : '' }}">
                        <a href="{{ route('pages.show', $menuItem->link) }}" data-solution-link data-anchor="{{ $menuItem->link }}">
                            <span>{{ $menuItem->title }}</span>
                            <i class="icon-chevron-down text-[1.8rem] lg-min:hidden"></i>
                        </a>
                        <ul data-dropdown-content class="dropdown-content list-none">
                            @foreach ($menuItem->children as $child)
                                <li class="{{ "{$urlParentSlug}/{$slug}" === $child->link ? 'isCurrent' : '' }}"><a href="{{ route('pages.show', $child->link) }}">{{ $child->title }}</a></li>
                            @endforeach
                        </ul>
                    </li>
                @else
                    <li class="{{ $slug === $menuItem->link ? 'isCurrent' : '' }}"><a href="{{ route('pages.show', $menuItem->link) }}"><span>{{ $menuItem->title }}</span></a></li>
                @endif
            @endif
        @endforeach
    </ul>

    <form
        data-search-content
        action="{{ route('pages.search') }}" method="POST"
        class="search-content {{ isset($searchIsActive) && $searchIsActive ? 'isActive' : '' }}"
    >
        @csrf

        <input name="search" type="text" id="search" value="{{ request('search') }}" placeholder="{{ __('Search in Paraflow') }}">
        <div class="flex gap-2">
            <button type="submit" class="btn btn-icon-only">
                <i class="icon-search text-[2.4rem] text-gray lg:text-black"></i>
            </button>
            <button data-search-close type="button" class="btn btn-icon-only">
                <i class="icon-close text-[2.2rem] text-gray"></i>
            </button>
        </div>
    </form>
</nav>