<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
    <div class="app-brand">
        <a href="{{ route('admin.home') }}" class="app-brand-link">
            <span class="app-brand-logo">
                <img src="{{ asset('storage/admin/images/kipo_logo_engine.png') }}" height="64" alt="Kipo Engine logo">
            </span>
        </a>

        <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-xl-none">
            <i class="bx bx-chevron-left bx-sm align-middle"></i>
        </a>
    </div>

    <div class="menu-inner-shadow"></div>

    <ul class="menu-inner py-1">
        <li class="menu-item @if (Route::is('admin.home')) active @endif">
            <a href="{{ route('admin.home') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-home-circle"></i>
                <div data-i18n="Analytics">{{ admin_trans('dashboard') }}</div>
            </a>
        </li>

        <li class="menu-item @if (Route::is('admin.pages.*')) active @endif">
            <a href="{{ route('admin.pages.index') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-file-html"></i>
                <div data-i18n="Pages">{{ admin_trans('headings.pages') }}</div>
            </a>
        </li>

        <li class="menu-item @if (Route::is('admin.products.*')) active @endif">
            <a href="{{ route('admin.products.index') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-keyboard"></i>
                <div data-i18n="Products">{{ admin_trans('headings.products') }}</div>
            </a>
        </li>

        <li class="menu-item @if (Route::is('admin.projects.*')) active @endif">
            <a href="{{ route('admin.projects.index') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-chart"></i>
                <div data-i18n="Projects">{{ admin_trans('headings.projects') }}</div>
            </a>
        </li>

        <li class="menu-item @if (Route::is('admin.solutions.*')) active @endif">
            <a href="{{ route('admin.solutions.index') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-server"></i>
                <div data-i18n="Solutions">{{ admin_trans('headings.solutions') }}</div>
            </a>
        </li>

        <li class="menu-item @if (Route::is('admin.news.*')) active @endif">
            <a href="{{ route('admin.news.index') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-news"></i>
                <div data-i18n="News">{{ admin_trans('headings.news') }}</div>
            </a>
        </li>

        <li class="menu-item @if (
            Route::is('admin.clients.*')
            or Route::is('admin.businesses.*')
            or Route::is('admin.admins.*')
            ) active open @endif">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bxs-user"></i>
                <div data-i18n="Users">{{ admin_trans('headings.users') }}</div>
            </a>

            <ul class="menu-sub">
                <li class="menu-item @if (Route::is('admin.clients.*')) active @endif">
                    <a href="{{ route('admin.clients.index') }}" class="menu-link">
                        <div data-i18n="Clients">{{ admin_trans('headings.clients') }}</div>
                    </a>
                </li>

                <li class="menu-item @if (Route::is('admin.businesses.*')) active @endif">
                    <a href="{{ route('admin.businesses.index') }}" class="menu-link">
                        <div data-i18n="Businesses">{{ admin_trans('headings.businesses') }}</div>
                    </a>
                </li>

                <li class="menu-item @if (Route::is('admin.admins.*')) active @endif">
                    <a href="{{ route('admin.admins.index') }}" class="menu-link">
                        <div data-i18n="Admins">{{ admin_trans('headings.administrators') }}</div>
                    </a>
                </li>
            </ul>
        </li>

        <li class="menu-item @if (Route::is('elfinder.index')) active @endif">
            <a href="{{ route('elfinder.index') }}" class="menu-link">
                <i class="menu-icon tf-icons bx bxs-file-find"></i>
                <div data-i18n="Analytics">{{ admin_trans('file_manager') }}</div>
            </a>
        </li>

        <li class="menu-item @if (Route::is('admin.settings.*')) active open @endif">
            <a href="javascript:void(0);" class="menu-link menu-toggle">
                <i class="menu-icon tf-icons bx bxs-cog"></i>
                <div data-i18n="Settings">{{ admin_trans('headings.settings') }}</div>
            </a>

            <ul class="menu-sub">
                <li class="menu-item @if (Route::is('admin.settings.domains.*')) active @endif">
                    <a href="{{ route('admin.settings.domains.index') }}" class="menu-link">
                        <div data-i18n="Domains">{{ admin_trans('headings.domains') }}</div>
                    </a>
                </li>
            </ul>

            <ul class="menu-sub">
                <li class="menu-item @if (Route::is('admin.settings.menus.*')) active @endif">
                    <a href="{{ route('admin.settings.menus.index') }}" class="menu-link">
                        <div data-i18n="Menus">{{ admin_trans('headings.menus') }}</div>
                    </a>
                </li>
            </ul>
        </li>

    </ul>

    @if (isset($domain))
        <div class="clientLogo">
            @php
                if (str()->startsWith($domain->domain, 'http')) {
                    $url = $domain->domain;
                } else {
                    $url = 'https://' . $domain->domain;
                }
            @endphp
            <a href="{{ $url }}" target="_blank">
                @if (isset($domain->logo))
                    <img src="{{ asset('storage/' . $domain->logo) }}" width="100%" alt="Kipo Engine logo">
                @else
                    <img src="{{ asset('storage/admin/images/kipo_logo_engine.png') }}" width="100%" alt="Kipo Engine logo">
                @endif
                <span>{{ $domain->domain }} <i class="bx bx-link-external"></i></span>
            </a>
        </div>
    @endif
</aside>