<!DOCTYPE html>
<html lang="{{ config('app.locale') === 'bg' ? 'bg' : 'en' }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/x-icon" href="{{ asset('storage/images/favicon.png') }}">
    {{ $meta }}
    @vite(['resources/front/sass/styles.scss'])
</head>


<body class="{{ $bodyClass }}">
    {{ $header }}

    <main>
        {{ $slot }}
    </main>

    {{ $footer }}

    <button
        data-scroll-up
        class="btn btn-primary btn-icon-only hidden fixed bottom-13 right-13 z-[10]
                !w-[5.6rem] !h-[5.6rem] !rounded-[50%]
                desktop:bottom-6 desktop:right-6
                md:bottom-3 md:right-3"
    >
        <i class="icon-chevron-up text-white"></i>
    </button>

    @vite(['resources/front/js/script.js'])
</body>

</html>
