<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed">

<head>
    <meta charset="UTF-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Admin Panel</title>
    @vite(['resources/admin/sass/app.scss'])
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            @include('partials.admin.layout._menu')

            <!-- Layout container -->
            <div class="layout-page">

                {{ $horizontalNav ?? null }}

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-xxl flex-grow-1 container-p-y">
                        {{ $slot }}
                    </div>
                    <!-- / Content -->

                    @include('partials.admin.layout._footer')

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>

        @if (session()->has('success'))
        <div class="position-fixed bottom-0 end-0 me-4 alert alert-site alert-primary" role="alert">
            {{ session()->get('success') }}
        </div>
        @endif

        @if (session()->has('error'))
        <div class="position-fixed bottom-0 end-0 me-4 alert alert-site alert-danger" role="alert">
            {{ session()->get('error') }}
        </div>
        @endif
    </div>
    <!-- / Layout wrapper -->

    <div id="loader-main-bg">
        <div id="loader">
            <div class="spinner-border text-success" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    @vite(['resources/admin/js/app.js'])

    @if (str()->contains(Route::currentRouteName(), ['.edit', '.create']))
        @vite(['resources/admin/js/tinymce.js'])
        @vite(['resources/admin/js/categories-select.js'])
    @endif
</body>

</html>