<section>
    @if ($section->title)
        <div class="container">
            @if (isset($breadcrumbs) && count($breadcrumbs) > 0)
                <x-pages.breadcrumbs :breadcrumbs="$breadcrumbs" :section="$section" />
            @endif
            <div class="mb-6 lg:mb-4 md:mb-3">
                <h1 class="mb-1 last:mb-0 text-[5.6rem] text-left text-balance lg:text-[4.2rem] md:text-[3.2rem]">
                    {{ $section->title }}
                </h1>
            </div>
        </div>
    @endif
    <div class="relative container lg:p-0">
        <div>
            <div>
                <div>
                    <div class="box-border relative h-[72rem] p-[16rem_10rem] lg:p-[8rem_5rem] lg:h-[60rem] md:p-[1.6rem] md:h-auto md:min-h-[30rem] sm:flex sm:flex-col">
                        @if ($section->subtitle || $section->description)
                            <div class="editor relative z-[2] w-full max-w-[75rem] max-h-40 mb-[4rem] p-[4rem] rounded-xl bg-white md:p-2 md:max-h-full">
                                @if ($section->subtitle)
                                    <h4 class="text-balance">{{ $section->subtitle }}</h4>
                                @endif
                                <br>
                                @if ($section->description)
                                    <p>{{ $section->description }}</p>
                                @endif
                            </div>
                        @endif
                        <img
                            class="absolute top-0 left-0 w-full h-full object-cover rounded-t-xl md:rounded-t-[1.2rem]"
                            src="{{ asset('storage/' . $section->image) }}"
                            alt="{{ $section->title }}"
                        >
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
