<section class="s-image-2-4 container section-spacing-xs relative grid grid-cols-2 grid-cols-2 gap-0 xl:grid-cols-1 xl:gap-0 ">
    <div class="relative w-full overflow-hidden xl:max-h-[50rem] xl:aspect-image-sm xl:rounded-t-xl xl:rounded-b-[0]  rounded-r-xl">
        <img class="absolute top-0 left-0 h-full w-full object-cover overflow-hidden" src="{{ asset('storage/' . $section->image) }}" alt="{{ $section->title }}">
    </div>

    <div class="flex flex-col col-start-1 row-start-1  xl:row-start-2 bg-white xl:rounded-b-xl  xl:rounded-t-[0]  rounded-l-xl">
        <div class="editor">
            <div class=" p-6 xl:p-5 lg:p-3 md:px-[1.6rem] ">
                <div class="flex flex-col gap-2">
                    <div class="flex items-center gap-2">
                        <img class="w-6 [object-fit:contain]" src="{{ asset('storage/' . $section->title_image) }}" alt="{{ $section->title }}">
                        <div class="flex flex-col">
                            @if ($section->subtitle)
                                <h4 class="caption text-primary">{{ $section->subtitle }}</h4>
                            @endif
                            <h3 class="line-clamp-2">{{ $section->title }}</h3>
                        </div>
                    </div>

                    <div class="editor">
                        <p>{!! $section->description !!}</p>
                    </div>

                    @php
                        $partners = $section->children->where('sectionType.type', 'tech_partners')->first();
                    @endphp

                    @if ($partners)
                        <div class="flex flex-col rounded-lg border-[1px] border-[rgba(103,124,139,0.4)] p-2">
                            <p class="mb-1 caption-mini text-gray">{{ $partners->title ?? 'ТЕХНОЛОГИЧНИ ПАРТНЬОРИ:' }}</p>

                            <div class="flex flex-wrap items-center gap-2">
                                @foreach ($partners->sectionElements as $partner)
                                    <img class=" max-w-12 h-6 [object-fit:contain]" src="{{ asset('storage/' . $partner->image) }}" alt="{{ $partner->title }}">
                                @endforeach
                            </div>
                        </div>
                    @endif

                    @if ($section->button_text)
                        <a class="place-self-start mt-2 btn btn-primary btn-lg btn-icon" href="{{ $section->button_link }}">
                            <span>{{ $section->button_text }}</span>
                            <i class="icon-arrow-right"></i>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>