<section class="section-spacing">
    @if ($section->title)
        <div class="container">
            <h2 class="mb-3 text-[5.6rem] md:text-[4rem]">{{ $section->title }}</h2>
        </div>
    @endif
    <div class="container grid grid-cols-3 gap-[3.2rem_1.6rem] xl:grid-cols-1 md:gap-[1.6rem]">
        @foreach ($section->sectionElements as $index => $element)
            @if ($element->sectElType->type == 'review_item')
                <article
                    data-popup-root data-popup-index={{ $index }}
                    class="popup-testimonial-0 relative flex flex-col justify-between p-[4rem] rounded-xl bg-white no-underline md:p-[2.4rem]"
                >
                    @if ($element->text_content)
                        <div class="flex flex-col mb-1">
                            <div class="content text-[2.2rem] italic text-gray ">
                                "{{ $element->text_content }}"
                            </div>
                            <a href="#popup-testimonial-{{ $index }}" class="popup-open">Виж още</a>
                        </div>
                    @endif
                    <div class="">
                        @if ($element->author)
                        <p class="m-0 font-bold">{{ $element->author }}</p>
                        @endif
                        @if ($element->position)
                            <p class="m-0 text-[1.8rem] text-grey">{{ $element->position }}</p>
                        @endif
                    </div>
                </article>
                <article
                    id="popup-testimonial-{{ $index }}"
                    class="relative flex flex-col justify-between p-[4rem] pt-6 rounded-xl bg-white no-underline md:p-[2.4rem] md:pt-6 mfp-hide"
                >
                    <button class="popup-close absolute top-2 right-2 btn btn-icon-only" type="button">
                        <i class="icon-close"></i>
                    </button>
                    @if ($element->text_content)
                        <div class="flex flex-col mb-1">
                            <div class="content text-[2.2rem] italic text-gray ">
                                "{{ $element->text_content }}"
                            </div>
                        </div>
                    @endif
                    <div class="">
                        @if ($element->author)
                            <p class="m-0 font-bold">{{ $element->author }}</p>
                        @endif
                        @if ($element->position)
                            <p class="m-0 text-[1.8rem] text-grey">{{ $element->position }}</p>
                        @endif
                    </div>
                </article>
            @endif
        @endforeach
    </div>
    @if ($section->button_text)
        <div class="container flex justify-center mt-[3.2rem]">
            <a class="btn btn-white md:w-full" href="{{ $section->button_link }}">
                <span>{{ $section->button_text }}</span>
            </a>
        </div>
    @endif
  </section>