<section class="section-spacing py-8 px-12  rounded-xl bg-infobox xl:py-6 xl:px-8 lg:py-4 lg:px-6 md:py-[3.2rem] md:px-[3.2rem] xs:px-[1.6rem]">
    <div class="grid grid-cols-1 gap-2 subtitle lg:grid-cols-1 md:gap-1">
        @if ($section->image)
            <div class="grid  grid-cols-[22rem_1fr]  gap-5 lg:grid-cols-1 md:gap-2">
                <img class="w-full max-w-[32rem]" src="{{ asset('storage/' . $section->image) }}" alt="{{ $section->title }}">
        @else
            <div class="grid grid-cols-1 gap-2 subtitle lg:grid-cols-1 md:gap-1"
        @endif

            <div class="flex flex-col  gap-[2.4rem]">
                <h4 class="m-0 caption text-primary">{{ $section->title }}</h4>

                <div class="flex flex-col gap-[0.5rem]">
                    <div class="flex gap-[2.4rem] md:flex-col md:gap-[1.6rem]">
                        <strong class="min-w-15">{{ __('Organization') }}</strong>
                        <p>{{ $section->organization }}</p>
                    </div>
                    <div class="flex gap-[2.4rem] md:flex-col md:gap-[1.6rem]">
                        <strong class="min-w-15">{{ __('Industry') }}</strong>
                        <p>{{ $section->industry }}</p>
                    </div>
                    <div class="flex gap-[2.4rem] md:flex-col md:gap-[1.6rem]">
                        <strong class="min-w-15">{{ __('Solution') }}</strong>
                        <p>{{ $section->solution }}</p>
                    </div>
                    <div class="flex gap-[2.4rem] md:flex-col md:gap-[1.6rem]">
                        <strong class="min-w-15">{{ __('Products') }}</strong>
                        <p>{{ $section->products }}</p>
                    </div>
                    <div class="flex gap-[2.4rem] md:flex-col md:gap-[1.6rem]">
                        <strong class="min-w-15">{{ __('Location') }}</strong>
                        <p>{{ $section->location }}</p>
                    </div>
                    <div class="flex gap-[2.4rem] md:flex-col md:gap-[1.6rem]">
                        <strong class="min-w-15">{{ __('Website') }}</strong>
                        <p>{{ $section->website }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
