<section class="section-spacing container" data-tab-content>
  @if ($section->title)
    <h2 class="mb-3 text-[5.6rem] md:text-[4rem]">{{$section->title}}</h2>
  @endif

  @php
    $industryTabs = [];
    $industryContent = [];
    foreach ($section->children as $child) {
        foreach ($child->children as $child) {
            if ($child->sectionType->type == 'industry_tab') {
                $industryTabs[] = $child;
            }

            if ($child->sectionType->type == 'industry_content') {
                $industryContent[] = $child;
            }
      }
    }
  @endphp

    @if ($industryTabs)
    <div class="grid grid-cols-[50rem_1fr] gap-[3.2rem] xl:grid-cols-1">
        <div class="flex flex-col gap-[1.6rem] xl:grid grid-cols-2 gap-2 lg:grid-cols-1">
            @foreach ($industryTabs as $key => $element)
                @php
                    $key = $key + 1;
                @endphp
                <a
                    class="c-industry-tab flex items-center gap-[2rem] p-[2.4rem_4rem] rounded-md bg-white-2 no-underline overflow-hidden md:p-[1.6rem_4rem] {{ $key == 1 ? 'active' : '' }}"
                    data-tab="{{ $key }}"
                >
                    <img class="w-[4.8rem]"
                        src="{{ asset('storage/' . $element->image) }}"
                        alt="{{ $element->title }}">
                    <p class="m-0">{{ $element->title }}</p>
                </a>
            @endforeach
        </div>
    @endif

    @if ($industryContent)
        <div class="w-full grid grid-cols-1">
            @foreach ($industryContent as $key => $content)
                @php
                    $key = $key + 1;
                    $industryContentList = $content->children->where('sectionType.type', 'industry_content_list');
                @endphp
                <div
                    id="popup-tab-content-{{ $key }}"
                    class="c-industry-content col-start-1 col-end-1 row-start-1 row-end-1 xl:hidden self-start w-full p-6 rounded-xl bg-white-2 desktop:p-4 {{ $key == 1 ? 'active' : '' }}"
                    data-content="{{ $key }}"
                >
                    <div class="flex justify-between items-start">
                        <h3 class="mb-6 f desktop:mb-4">{{ $content->title }}</h3>
                        <button class="btn btn-icon-only popup-close xl-min:hidden">
                            <i class="icon-close"></i>
                        </button>
                    </div>
                    <div class="content columns-3 gap-6 desktop:columns-2 desktop:gap-4 xl:columns-3 lg:columns-2 md:columns-1 md:gap-2">
                        @foreach ($industryContentList as $key => $list)
                            <a class="flex justify-between items-start mb-[2.4rem] no-underline" href="{{ $list->link }}">
                                <span class="text-primary text-[1.6rem] font-bold">{{ $list->title }}</span>
                                <i class="flex-[0_0_auto] icon-chevron-right text-primary text-[2.4rem]"></i>
                            </a>
                            <ul class="list-none mb-[2.4rem]">
                                @foreach ($list->sectionElements as $element)
                                    @if ($element->sectElType->type == 'industry_content_list_item')
                                        <li class="mb-[2.4rem]">{{ $element->title }}</li>
                                    @endif
                                @endforeach
                            </ul>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
    @endif
  </div>
</section>
