<section class="section-spacing md:mb-[6rem]" data-hero-slider>
    <div class="container">
        <div class="mb-10 xl:mb-6 lg:mb-4 md:mb-3">
            <h1 class="mb-1 last:mb-0 text-[5.6rem] text-center text-balance lg:text-[4.2rem] md:text-[3.2rem]">
                {{ $section->title }}
            </h1>
        </div>
    </div>
    <div class="relative container lg:p-0">
        <div class="swiper hero swiper-fade swiper-initialized swiper-horizontal swiper-watch-progress swiper-backface-hidden">
            <div class="swiper-wrapper h-[72rem] lg:h-[60rem] md:h-auto md:min-h-[40rem]">
                @foreach ($section->sectionElements as $element)
                    @if ($element->sectElType->type == 'hero_slider_item')
                        <div class="swiper-slide swiper-slide-visible swiper-slide-fully-visible swiper-slide-active">
                            <div class="box-border relative h-[72rem] p-[16rem_10rem] lg:p-[8rem_5rem] lg:h-[60rem] md:p-[1.6rem] md:h-auto md:min-h-[40rem] sm:flex sm:flex-col">
                                <div class="editor relative z-[2] w-full max-w-[75rem] max-h-40 mb-[4rem] p-[4rem] rounded-xl bg-white md:p-2 md:max-h-full">
                                    <h4 class="text-balance">{{ $element->title }}</h4>
                                    <br>
                                    <p>{{ $element->description }}</p>
                                </div>

                                <div class="buttons-wrapper relative z-[2] flex gap-[2rem] sm:flex sm:flex-col sm:mt-auto">
                                    <a class="btn btn-white" href="{{ $element->button_link }}">{{ $element->button_text }}</a>
                                    <a class="btn btn-primary p-[1.6rem_3.2rem]" href="{{ $element->button_right_link }}">{{ $element->button_right_text }}</a>
                                </div>

                                <img
                                    class="absolute top-0 left-0 w-full h-full object-cover rounded-xl"
                                    src="{{ asset('storage/' . $element->image) }}"
                                    alt="{{ $element->title }}"
                                >
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
        <div class="swiper-pagination-bullets-custom"></div>
    </div>
</section>
