<section class="section-spacing container">
    @if (isset($section->title) && $section->title !== 'no_title')
        <h2 class="mb-3 text-[5.6rem] md:text-[4rem]">{{ $section->title }}</h2>
    @endif

    @php
        $favoriteItems = \App\Models\Page::where('page_type_id', $section->page_type_id)->where('is_favorite', true)->latest()->limit($section->number_items)->get();
    @endphp

    <div class="grid grid-cols-3 gap-[1.6rem] lg:grid-cols-1">
        @if ($section->sectionElements->isNotEmpty())
            @foreach ($section->sectionElements as $key => $element)
                @if ($element->sectElType->type == 'card_full_width_item')
                    <div class="relative flex flex-col gap-[3.2rem] rounded-xl bg-[#FEFEFE] md:gap-[3.2rem]">
                        <a class="link-absolute-full" href="{{ $element->link }}"></a>
                        <img class="flex-[0_0_auto] object-cover rounded-t-lg h-[40rem] xl:h-[35vw] md:h-[60vw]"
                            src="{{ asset('storage/' . $element->image) }}"
                            alt="{{ isset($element->title) ? $element->title : 'Card Image' . $key + 1 }}"
                        >
                        <div class="flex-[1_1_100%] flex flex-col gap-[3.2rem] md:gap-[1.6rem]">
                            @if ($element->title)
                                <h3 class="m-0 text-[2.4rem] font-bold line-clamp-2 px-[1.6rem] md:line-clamp-3">
                                    {{ $element->title }}
                                </h3>
                            @endif

                            <div class="m-0 text-[2rem] text-[#677C8B] min-h-[6.0rem] line-clamp-2 md:line-clamp-4 px-[1.6rem]">
                                <p>{{ $element->description }}</p>
                            </div>

                            <a class="btn btn-primary btn-icon mb-[3.2rem] mx-[1.6rem] place-self-start" href="{{ $element->link }}">
                                <span>{{ $element->link_text }}</span>
                                <i class="icon-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                @endif
            @endforeach
        @elseif ($favoriteItems->isNotEmpty())
            @foreach ($favoriteItems as $key => $item)
                <div class="relative flex flex-col gap-[3.2rem] rounded-xl bg-[#FEFEFE] md:gap-[3.2rem]">
                    <a class="link-absolute-full" href="{{ route('pages.show', $item->slug) }}"></a>
                    <img class="flex-[0_0_auto] object-cover rounded-t-lg h-[40rem] xl:h-[35vw] md:h-[60vw]"
                        src="{{ asset('storage/' . $item->cover_image) }}"
                        alt="{{ isset($item->title) ? $item->title : 'Card Image' . $key + 1 }}"
                    >
                    <div class="flex-[1_1_100%] flex flex-col gap-[3.2rem] md:gap-[1.6rem]">
                        @if ($item->title)
                            <h3 class="m-0 text-[2.4rem] font-bold line-clamp-2 px-[1.6rem] md:line-clamp-3">
                                {{ $item->title }}
                            </h3>
                        @endif

                        <div class="m-0 text-[2rem] text-[#677C8B] min-h-[6.0rem] line-clamp-2 md:line-clamp-4 px-[1.6rem]">
                            <p>{{ $item->description }}</p>
                        </div>

                        <a class="btn btn-primary btn-icon mb-[3.2rem] mx-[1.6rem] place-self-start" href="{{ route('pages.show', $item->slug) }}">
                            <span>{{ __('Learn more')}}</span>
                            <i class="icon-arrow-right"></i>
                        </a>
                    </div>
                </div>
            @endforeach
        @endif
    </div>
    @if ($section->button_text)
        <div class="w-full flex justify-center mt-[3.2rem] md:mt-[1.6rem]">
            <a class="btn btn-white md:w-full" href="{{ $section->button_link }}">
                <span>{{ $section->button_text }}</span>
            </a>
        </div>
    @endif
</section>
