<x-front-layout>
    <x-slot:meta>
        <title>{{ $page->meta_title }}</title>
        <meta name="description" content="{{ $page->meta_description }}">
    </x-slot:meta>

    <x-slot:bodyClass> </x-slot:bodyClass>

    <x-slot:bodystyle>
        background-color: {{ $backgroundColors[$page->background_color_id] ?? '' }};
    </x-slot:bodystyle>

    <x-slot:header>
        @include('partials.front._header')
    </x-slot:header>

    @php
        $staticHeroSection = $page->sections->where('sectionType.type', 'static_hero')->first();
        $heroSliderSection = $page->sections->where('sectionType.type', 'hero_slider')->first();
        $isInWrapper = $page->sections->where('is_in_wrapper', 1);
        $isNotInWrapper = $page->sections->where('is_in_wrapper', 0);
    @endphp

    @if ($staticHeroSection)
        @include('front.sections.' . $staticHeroSection->sectionType->type, ['section' => $staticHeroSection])
    @endif

    @if (!$heroSliderSection && !$staticHeroSection)
        <section class="section-spacing-sm">
            <div class="container">
                <x-pages.breadcrumbs :breadcrumbs="$breadcrumbs" :page="$page" />

                <div>
                    <h1 class="mb-1 last:mb-0 text-[5.6rem]  text-left  text-balance lg:text-[4.2rem] md:text-[3.2rem]">{{ $page->title }}</h1>
                    <p>{{ $page->description }}</p>
                </div>

            </div>
        </section>
    @endif

    @if ($isInWrapper->isNotEmpty())
        <div class="content-wrapper container section-spacing lg:p-0">
            <div class="py-6 px-8 bg-white rounded-b-xl xl:py-4 xl:px-6 lg:py-3 lg:px-4 md:p-[1.6rem]">
                @foreach ($isInWrapper as $section)
                    @include('front.sections.' . $section->sectionType->type)
                @endforeach
            </div>
        </div>
    @endif

    @foreach ($isNotInWrapper as $section)
        @if ($section->id !== $staticHeroSection?->id)
            @include('front.sections.' . $section->sectionType->type)
        @endif
    @endforeach

    <x-slot:footer>
        @include('partials.front._footer')
    </x-slot:footer>
</x-front-layout>
