<x-front-layout>
    <x-slot:meta>
        <title>{{ $page->meta_title }}</title>
        <meta name="description" content="{{ $page->meta_description }}">
    </x-slot:meta>

    <x-slot:bodyClass> </x-slot:bodyClass>

    <x-slot:bodystyle>
        background-color: {{ $backgroundColors[$page->background_color_id] ?? '' }};
    </x-slot:bodystyle>

    <x-slot:header>
        @include('partials.front._header', ['searchIsActive' => true])
    </x-slot:header>

    <section class="section-spacing-sm">
        <div class="container">
            <x-pages.breadcrumbs :breadcrumbs="$breadcrumbs" :page="$page" />

            <div>
                <h1 class="mb-1 last:mb-0 text-[5.6rem]  text-left  text-balance lg:text-[4.2rem] md:text-[3.2rem]">{{ $page->title }}</h1>
                <p>{{ $page->description }}</p>
            </div>

        </div>
    </section>

    <section class="container section-spacing">
        <div class="flex flex-col gap-8 xl:gap-6 lg:gap-5 md:gap-4 sm-[1.6rem]">
            @foreach ($pages as $page)
                <div class="flex flex-col justify-start items-start">
                    <a
                        href="{{ route('pages.show', $page->slug) }}"
                        class="search-result flex justify-start items-start gap-6 mb-[2.4rem] no-underline xl:gap-5 lg:gap-4 md:gap-3 sm-[1.6rem]"
                    >
                        <span class="text-primary text-[1.6rem] font-bold">{{ $page->title }}</span>
                        <i class="flex-[0_0_auto] icon-chevron-right text-primary text-[2.4rem] animate-arrow "></i>
                    </a>
                    <div class="editor">
                        <p>{{ $page->description }}</p>
                    </div>
                </div>
            @endforeach

            {{ $pages->links() }}
        </div>
    </section>

    <x-slot:footer>
        @include('partials.front._footer')
    </x-slot:footer>

</x-front-layout>
