@props(['breadcrumbs', 'section' => null, 'page' => null])

@if (isset($breadcrumbs) && count($breadcrumbs) > 0)
    <ul class="list-none flex flex-wrap items-center text-grey mb-[1.6rem] md:mb-[1.0rem]">
        @foreach ($breadcrumbs as $breadcrumb)
            <li>
                @if ($breadcrumb['is_last'])
                    <span class="text-[1.4rem] text-gray cursor-default">{{ str()->upper(__($breadcrumb['name'])) }}</span>
                @else
                    <a
                        href="{{ $breadcrumb['link'] }}"
                        class="no-underline text-[1.4rem] text-gray hover:text-primary"
                    >{{ str()->upper(__($breadcrumb['name'])) }}</a>
                    <i class="mx-1 icon-chevron-right text-[1.6rem] text-gray"></i>
                @endif
            </li>
        @endforeach
    </ul>
@endif
