@props(['ths', 'records', 'route', 'canEdit' => true, 'hasStatus' => true])

<div class="table-responsive">
    <table id="entityList" class="table">
        <thead>
            <tr>
                @foreach ($ths as $th)
                <th>{{ $th }}</th>
                @endforeach

                @if ($hasStatus)
                <th width="10%">{{ admin_trans('active') }}</th>
                @endif

                <th width="10%">{{ admin_trans('actions') }}</th>
            </tr>
        </thead>
        <tbody class="table-border-bottom-0">
            @forelse ($records as $record)
            <tr>
                @if (!empty($record->title))
                <td>
                    <a href="{{ route($route . '.edit', $record->id) }}">{{ $record->title }}</a>
                </td>
                @endif

                @if (!empty($record->domain))
                <td>
                    <a href="{{ route($route . '.edit', $record->id) }}">{{ $record->domain }}</a>
                </td>
                @endif

                @if (!empty($record->name))
                <td>
                    <a href="{{ route($route . '.edit', $record->id) }}">{{ $record->name }}</a>
                </td>
                @endif

                @if ($hasStatus)
                <td class="text-center" width="10%">
                    <x-admin.forms.switch-active :route="$route" :record="$record" />
                </td>
                @endif

                <td class="text-center" width="10%">
                    <x-admin.forms.edit-record :route="$route" :record="$record" :canEdit="$canEdit" />
                </td>
            </tr>

            @empty
            <tr>
                <td colspan="3">{{ admin_trans('no_records') }}.</td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <div class="pt-4 px-4">{{ $records->links() }}</div>
</div>