@props(['parent'])

<ol class="dd-list">
    @foreach ($parent->children as $item)
        <li class="dd-item card" data-id="{{ $item->id }}">
            <section class="dd-content">
                <div class="dd-handle">
                    <i class="bi bi-grip-vertical"></i>
                </div>

                <div class="p-1">
                    <small>{{ admin_trans('sections.type') }}: {{ str()->of($item->sectionType->type)->title()->replace('_', ' ') }}</small><br>

                    <img
                        src="{{ !empty($item->cover_image) && $item->cover_image !== ''
                            ? asset('storage/' . $item->cover_image)
                            : (!empty($item->sectionType->cover_image) && $item->sectionType->cover_image !== ''
                                ? asset('storage/' . $item->sectionType->cover_image)
                                : asset('storage/admin/images/no_image.jpg')) }}"
                        height="80"
                        alt="{{ $item->title }}"
                    >
                </div>

                <div class="sectionMain p-1">
                    <h5 class="m-0 p-0">{{ $item->title }}</h5>

                    <div class="sectionButtons">
                        <div class="errorMessage" role="alert"></div>
                        <a href="{{ route('admin.sections.edit', $item->id) }}" class="btn btn-primary" aria-label="Edit section">
                            {{ admin_trans('edit') }}
                        </a>

                        <button
                            type="button"
                            class="sectionDeleteBtn btn btn-danger"
                            data-id="{{ $item->id }}"
                            data-route="{{ route('admin.sections.destroy', $item->id) }}"
                        >
                            {{ admin_trans('delete') }}
                        </button>

                        <x-admin.forms.switch-active-noform route="admin.sections" :record="$item" />
                    </div>
                </div>
            </section>

            @if (count($item->children) > 0)
                <x-admin.nestable-sections-list-children :parent="$item" />
            @endif
        </li>
    @endforeach
</ol>

