<section class="mt-3 mb-4">
    <h2 class="h3">{{ admin_trans('headings.section_elements') }}</h2>

    <div class="dd" id="nestable" data-url="{{ route('admin.section-elements.sort') }}">
        <ol id="sectionElementList" class="dd-list">
            @foreach ($sectionElements as $item)
                <li class="dd-item card" data-id="{{ $item->id }}">
                    <section class="dd-content">
                        <div class="dd-handle">
                            <i class="bi bi-grip-vertical"></i>
                        </div>

                        <div class="p-3">
                            <img
                                src="{{ !empty($item->cover_image) && $item->cover_image !== ''
                                    ? asset('storage/' . $item->cover_image)
                                    : asset('storage/admin/images/no_image.jpg') }}"
                                height="120"
                                alt="{{ $item->admin_title }}"
                            >
                        </div>

                        <div class="sectionMain p-3">
                            <span class="badge bg-secondary">{{ Str::of($item->sectElType->type)->title()->replace('_', ' ') }}</span>
                            <h3>{{ $item->admin_title }}</h3>
                            <div class="sectionButtons">
                                <div class="errorMessage" role="alert"></div>
                                <a href="{{ route('admin.section-elements.edit', $item->id) }}" class="btn btn-primary" aria-label="Edit section element">
                                    {{ admin_trans('edit') }}
                                </a>

                                <button
                                    type="button"
                                    class="sectionElementDeleteBtn btn btn-danger"
                                    data-id="{{ $item->id }}"
                                    data-route="{{ route('admin.section-elements.destroy', $item->id) }}"
                                >
                                    {{ admin_trans('delete') }}
                                </button>
                            </div>
                        </div>
                    </section>
                </li>
            @endforeach
        </ol>
    </div>

    <a
        href="{{ route('admin.section-elements.create', ['section' => $section]) }}"
        id="sectionElementCreateBtn"
        class="btn btn-outline-secondary w-100 mt-3"
    >{{ admin_trans('section_elements.new') }}</a>
</section>

