@props(['recordName', 'records', 'route', 'routeParams' => [], 'hasActive' => true, 'hasFavorite' => false, 'showCoverImage' => false])

<ol class="dd-list">
    @foreach ($records as $item)
        <li class="dd-item card" data-id="{{ $item->id }}">
            <div class="dd-content ">
                <div class="dd-header">
                    <div class="dd-handle">
                        <i class="bi bi-grip-vertical"></i>
                    </div>

                    <div class="list-title">
                        @if ($showCoverImage)
                            <img
                                src="{{ asset('storage/' . $item->cover_image) ?? asset('storage/admin/images/no_image.jpg') }}"
                                alt="{{ $item->title ?? $item->name }}"
                                class="rounded-circle"
                                width="50"
                                height="50"
                            >
                        @endif

                        <a href="{{ route($route . '.edit', $item->id) }}">{{ $item->title ?? $item->name }}</a>

                        @if ($item->page_type)
                            <span class="badge bg-primary">{{ admin_trans('page.page_type_options.' . $item->page_type->name) }}</span>
                        @endif
                    </div>
                </div>

                <div class="list-edit">
                    @if ($hasFavorite)
                        <x-admin.forms.switch-favorite class="me-3" :route="$route" :record="$item" />
                    @endif

                    @if ($hasActive)
                        <x-admin.forms.switch-active class="me-3" :route="$route" :record="$item" />
                    @endif

                    <x-admin.forms.edit-record :route="$route" :routeParams="$routeParams" :recordName="$recordName" :record="$item" />
                </div>
            </div>

            @if (count($item->children) > 0)
                <x-admin.nestable-list
                    :records="$item->children->all()"
                    :recordName='$recordName'
                    :route="$route"
                    :routeParams="$routeParams"
                    :hasActive="$hasActive"
                />
            @endif
        </li>
    @endforeach
</ol>