@props(['name', 'value' => null, 'required' => false, 'editor' => false])
@php
if (str()->contains($name, '[')) {
    $oldValue = old(Str::of($name)->replace('[', '.')->remove(']')->toString(), $value);
} else {
    $oldValue = old($name, $value);
}
@endphp

<textarea
    {{ $attributes->merge([]) }}
    name="{{ $name }}"
    @required($required)
    class="form-control {{ $editor ? 'tinyMCE' : '' }}"
    @if ($editor) data-editor-route="{{ route('elfinder.tinymce5') }}" @endif
>{{ $oldValue }}</textarea>