@props(['route', 'record'])

<div {{ $attributes->merge(['class' => 'form-check btn ms-5 form-switch d-inline-block']) }}>
    <div {{ $attributes->merge(['class' => 'recordActive d-flex align-items-center']) }} action="{{ route($route . '.toggle-active', $record->id) }}">
        @csrf

        <input
            type="checkbox"
            name="record_active"
            id="record_active_{{ $record->id }}"
            class="form-check-input"
            data-id="{{$record->id}}"
            data-isactive="{{$record->is_active}}"
            {{ $record->is_active ? 'checked' : '' }}
        />

        <x-admin.forms.label class="ms-2 mt-1" :for="'record_active_' . $record->id" :name="admin_trans('active')" />

    </div>
</div>