@props(['pageTypes', 'page'])
<div class="mb-3">
    <x-admin.forms.label :for="'page_type_id'" :name="admin_trans('page.page_type')" :required="true" />
    <select name="page_type_id" id="page_type_id" class="form-select">
        <option value="">{{ admin_trans('page.select_page_type') }}</option>
        @foreach ($pageTypes as $pageType)
            <option
                value="{{ $pageType->id }}"
                {{ old('page_type_id', !empty($page) ? $page->page_type_id : 0) == $pageType->id ? 'selected' : '' }}
            >{{ admin_trans('page.page_type_options.' . $pageType->name) }}</option>
        @endforeach
    </select>
    <x-admin.forms.error :name="'page_type_id'" />
</div>