@props(['entity' => null, 'secondaryImageDeleteRoute' => ''])

<section class="card mb-4">
    <h5 class="card-header">{{ admin_trans('secondary_image') }}</h5>
    <div class="card-body">
        <div class="mb-3">
            <x-admin.forms.label name="secondary_image" />

            <div class="secondaryImage text-center">
                @if (!empty($entity->secondary_image))
                    <img src="{{ asset('storage/' . $entity->secondary_image) }}" width="100%" alt="Secondary Image" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
                @else
                    <img src="{{ asset('storage/admin/images/no_image.jpg') }}" width="100%" alt="No image">
                @endif
            </div>

            <div class="filePreview {{ old('secondary_image') ? '' : 'hidden' }}">
                <label for="secondary_image">Image Preview</label><br>
                <input type="hidden" class="secondary_image" name="secondary_image" value="{{ old('secondary_image', !empty($entity) ? $entity->secondary_image : null) }}">
                <img src="{{ old('secondary_image') ? asset('storage/' . old('secondary_image')) : '' }}" alt="Secondary Image" height="128">
            </div>

            <div class="parentSecondaryImgUploadBtn text-center mt-4">
                <button
                    type="button"
                    data-filemanagerroute="{{ route('elfinder.popup', 'secondary_image') }}"
                    data-inputid="secondary_image"
                    data-mimes="image"
                    class="secondaryImgUploadBtn btn btn-icon btn-primary popup_selector"
                >
                    <span class="tf-icons bx bx-image-add"></span>
                </button>

                @if (!empty($entity->secondary_image))
                    <button
                        type="button"
                        class="secondaryImgDeleteBtn btn btn-icon btn-danger"
                        data-deletesecondaryimageroute="{{ route($secondaryImageDeleteRoute, $entity) }}"
                    >
                        <span class="tf-icons bx bx-trash"></span>
                    </button>
                @endif
            </div>
            <x-admin.forms.error name="secondary_image" />
        </div>
    </div>
</section>