@props(['name', 'value' => null, 'type' => 'text', 'required' => false])
@php
    if (str()->contains($name, '[')) {
        $oldValue = old(Str::of($name)->replace('[', '.')->remove(']')->toString(), $value);
    } else {
        $oldValue = old($name, $value);
    }
@endphp

<input
    {{ $attributes->merge([]) }}
    type="{{ $type }}"
    name="{{ $name }}"
    class="form-control"
    value="{{ $oldValue }}"
    @required($required)
>