@props(['language', 'subdirectory' => null, 'entity' => null])

<fieldset {{ $attributes->merge(['id' => 'seoPanel-' . $language->id, 'class' => "seoPanel"]) }}>
    <legend>{{ admin_trans('seotool') }}</legend>

    <div class="row">
        <div class="col-6">
            <div class="mb-3">
                <x-admin.forms.label :for="'slug-' . $language->id" name="{{ admin_trans('seo.slug') }}" :required="true" />
                <x-admin.forms.input
                    :id="'slug-'.$language->id"
                    :name="$language->locale.'[slug]'"
                    :value="!empty($entity) ? $entity->translate($language->locale)->slug : null"
                    :required="true"
                />
                <span>{{ admin_trans('seo.optimal_length_left') }}:</span> <span class="slug_length"></span>
                <x-admin.forms.error :name="$language->locale.'.slug'" />
            </div>
            <div class="mb-3">
                <x-admin.forms.label :for="'meta_title-' . $language->id" name="{{ admin_trans('seo.meta_title') }}" :required="false" />
                <x-admin.forms.input
                    :id="'meta_title-'.$language->id"
                    :name="$language->locale . '[meta_title]'"
                    :value="!empty($entity) ? $entity->translate($language->locale)->meta_title : null"
                    :required="false"
                />
                <span>{{ admin_trans('seo.optimal_length_left') }}:</span> <span class="meta_title_length"></span>
                <x-admin.forms.error :name="$language->locale . '.meta_title'" />
            </div>
            <div class="mb-3">
                <x-admin.forms.label :for="'meta_description-' . $language->id" name="{{ admin_trans('seo.meta_description') }}" :required="false" />
                <x-admin.forms.textarea
                    :id="'meta_description-' . $language->id"
                    :name="$language->locale . '[meta_description]'"
                    :value="!empty($entity) ? $entity->translate($language->locale)->meta_description : null"
                    :required="false"
                    rows="3"
                />
                <span>{{ admin_trans('seo.optimal_length_left') }}:</span> <span class="meta_description_length"></span>
                <x-admin.forms.error :name="$language->locale . '.meta_description'" />
            </div>
        </div>
        <div class="col-6">
            <section class="seo-snippet-area">
                <small>{{ admin_trans('seo.google_search_preview') }}:</small>
                <div>
                    <span class="appName">{{ config('app.name') }}</span>
                    <div class="preview-link">
                        @if (!empty($entity))
                            @php
                                $urlPath = $entity->isRelation('ancestors') ? implode('/', $entity->getSlugParentsAttribute($language->locale)) : null
                            @endphp
                            {{ url('/') }}/{{$language->locale === 'bg' ? '' : $language->locale.'/'}}{{ empty($subdirectory) ? '' : $subdirectory . '/' }}{{ empty($urlPath) ? '' : $urlPath . '/' }}<span id="preview_slug-{{ $language->id }}">{{ $entity->translate($language->locale)->slug }}</span>
                        @else
                            {{ url('/') }}/{{$language->locale === 'bg' ? '' : $language->locale.'/'}}{{ empty($subdirectory) ? '' : $subdirectory . '/' }}<span id="preview_slug-{{ $language->id }}"></span>
                        @endif
                    </div>
                    <h3>
                        @if (!empty($entity))
                            <a
                                href="{{ url('/') }}/{{locale_prefix($language->locale)}}{{ implode('/', $entity->getSlugTreeAttribute($language->locale)) }}"
                                id="preview_title-{{ $language->id }}"
                            >{{ $entity->translate($language->locale)->meta_title ?? '' }}</a>
                        @else
                            <a href="javascript:void(0)" id="preview_title-{{ $language->id }}"><span class="text-muted">{{ admin_trans('title_placeholder') }}</span></a>
                        @endif
                    </h3>
                    <div id="preview_description-{{ $language->id }}" class="desc-container">
                        @if (!empty($entity))
                            {{ str()->limit($entity->translate($language->locale)->meta_description, 150, '...') }}
                        @else
                            <span class="text-muted">{{ admin_trans('description_placeholder') }}</span>
                        @endif
                    </div>
                </div>
            </section>
        </div>
    </div>
</fieldset>