@props(['route', 'preview' => false, 'previewRoute' => null, 'saveAndClose' => true])

<div {{ $attributes->merge(['class' => 'recordFormMenu container-xxl']) }}>
    <div class="buttons">
        <button type="submit" name="save" value="save" class="btn btn-primary me-1">{{ admin_trans('save_btn') }}</button>

        @if ($saveAndClose)
            <button type="submit" name="save_close" value="save_close" class="btn btn-secondary me-1">
                {{ admin_trans('save_close_btn') }}
            </button>
        @endif

        <a href="{{ $route }}" class="btn btn-danger me-1" role="button">{{ admin_trans('close_btn') }}</a>

        @if ($preview)
            <a href="{{ $previewRoute }}" type="button" class="btn btn-info" role="button" target="_blank">{{ admin_trans('page.btn_preview') }}</a>
        @endif
    </div>
</div>