@props(['subdirectory' => null, 'entity' => null, 'hasSeo' => true, 'hasSubtitle' => false, 'hasTextContent' => false, 'editor' => false])

@php
    $languages = languages();
@endphp

<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
    @foreach($languages as $key => $language)
    <li class="nav-item">
        <button
            type="button"
            class="nav-link @if($key === 0) active @endif"
            role="tab"
            data-bs-toggle="tab"
            data-bs-target="#navs-top-{{ $language->code }}{{ !empty($entity) ? '-' . $entity->id : null }}"
            aria-controls="navs-top-{{ $language->code }}{{ !empty($entity) ? '-' . $entity->id : null }}"
            aria-selected="true"
        >
            {{$language->name}}
        </button>
    </li>
    @endforeach
</ul>
<div class="tab-content">
    @foreach($languages as $key => $language)
    <div
        class="tab-pane fade show @if($key === 0) active @endif"
        id="navs-top-{{ $language->code }}{{ !empty($entity) ? '-' . $entity->id : null }}"
        role="tabpanel"
    >
        <div class="mb-3">
            <x-admin.forms.label :for="'title-' . $language->id" :name="admin_trans('page.title')" :required="true" />
            <x-admin.forms.input
                :id="'title-' . $language->id"
                :name="$language->locale . '[title]'"
                :value="!empty($entity) ? $entity->translate($language->locale)->title : null"
                :required="true"
            />
            <x-admin.forms.error :name="$language->locale . '.title'" />
        </div>

        @if ($hasSubtitle)
            <div class="mb-3">
                <x-admin.forms.label :for="'subtitle-' . $language->id" :name="admin_trans('sections.subtitle')" :required="false" />
                <x-admin.forms.input
                    :id="'subtitle-' . $language->id"
                    :name="$language->locale . '[subtitle]'"
                    :value="!empty($entity) ? $entity->translate($language->locale)->subtitle : null"
                    :required="false"
                />
                <x-admin.forms.error :name="$language->locale . '.subtitle'" />
            </div>
        @endif

        <div class="mb-3">
            <x-admin.forms.label :for="'description-' . $language->id" :name="admin_trans('page.description')" :required="false" />
            <x-admin.forms.textarea
                :id="'description-' . $language->id"
                :name="$language->locale . '[description]'"
                :value="!empty($entity) ? $entity->translate($language->locale)->description : null"
                :required="false"
                rows="3"
                :editor="false"
            />
            <x-admin.forms.error :name="$language->locale . '.description'" />
        </div>

        @if ($hasTextContent)
            <div class="mb-3">
                <x-admin.forms.label :for="'text_content-' . $language->id" :name="admin_trans('page.text_content')" :required="false" />
                <x-admin.forms.textarea
                    :id="'text_content-' . $language->id"
                    :name="$language->locale . '[text_content]'"
                    :value="!empty($entity) ? $entity->translate($language->locale)->text_content : null"
                    :required="false"
                    rows="10"
                    :editor="$editor"
                />
                <x-admin.forms.error :name="$language->locale . '.text_content'" />
            </div>
        @endif

        @if ($hasSeo)
            <div id="{{ 'seoPanelVisibilitySwitch-' . $language->id }}" class="seoPanelVisibilitySwitch text-end">{{ admin_trans('seo_settings') }} <i class="bx bx-cog"></i></div>
            <x-admin.forms.entity.seo-section class="d-none" :language="$language" :subdirectory="$subdirectory" :entity="$entity ?? null" />
        @endif
    </div>
    @endforeach
</div>