@props(['route', 'recordName', 'record', 'routeParams' => [], 'canEdit' => true])

@php
if (empty($routeParams)) {
    $routeParams = $record;
} else {
    $routeParams[$recordName] = $record;
}
@endphp

<div class="btn-toolbar" role="toolbar" aria-label="Toolbar with button groups">
    <div class="btn-group" role="group" aria-label="First group">
        @if ($canEdit)
            <a href="{{ route($route . '.edit', $routeParams) }}" class="btn" role="button">
                <i class="bx bx-edit-alt"></i>
            </a>
        @endif

        <form
            class="deleteRecord @if (!empty($record->children)) hasChildren @endif"
            action="{{ route($route . '.destroy', $record->id) }}" method="post"
        >
            @csrf
            @method('DELETE')

            <button class="btn"><i class="bx bx-trash"></i></button>
        </form>
    </div>
</div>