@props(['entity' => null, 'coverImageDeleteRoute' => ''])

<section class="card mb-4">
    <h5 class="card-header">{{ admin_trans('cover_image') }}</h5>
    <div class="card-body">
        <div class="mb-3">
            <x-admin.forms.label :name="admin_trans('cover_image')" />

            <div class="coverImage text-center">
                @if (!empty($entity->cover_image))
                    <img src="{{ asset('storage/' . $entity->cover_image) }}" width="100%" alt="Cover Image" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
                @else
                    <img src="{{ asset('storage/admin/images/no_image.jpg') }}" width="100%" alt="No image">
                @endif
            </div>

            <div class="filePreview {{ old('cover_image') ? '' : 'hidden' }}">
                <label for="cover_image">{{ admin_trans('image_preview') }}</label><br>
                <input type="hidden" class="cover_image" name="cover_image" value="{{ old('cover_image', !empty($entity) ? $entity->cover_image : null) }}">
                <img src="{{ old('cover_image') ? asset('storage/' . old('cover_image')) : '' }}" alt="Cover Image" height="128">
            </div>

            <div class="parentCoverImgUploadBtn text-center mt-4">
                <button
                    type="button"
                    data-filemanagerroute="{{ route('elfinder.popup', 'cover_image') }}"
                    data-inputid="cover_image"
                    data-mimes="image"
                    class="coverImgUploadBtn btn btn-icon btn-primary popup_selector"
                >
                    <span class="tf-icons bx bx-image-add"></span>
                </button>

                @if (!empty($entity->cover_image))
                    <button
                        type="button"
                        class="coverImgDeleteBtn btn btn-icon btn-danger"
                        data-deletecoverimageroute="{{ route($coverImageDeleteRoute, $entity) }}"
                    >
                        <span class="tf-icons bx bx-trash"></span>
                    </button>
                @endif
            </div>
            <x-admin.forms.error name="cover_image" />
        </div>
    </div>
</section>