<x-admin-layout>
  <x-slot:horizontalNav>
    @include('partials.admin.layout._horizontal-nav')
  </x-slot:horizontalNav>

  <x-admin.page-heading :spanContent="admin_trans('headings.profile') . ' /'" :content="admin_trans('headings.edit')" />

  <div id="recordForm" class="card">
    <form class="card-body" action="{{ route('user-profile-information.update', $user->id) }}" method="POST" novalidate>
      @csrf
      @method('PUT')

      <x-admin.forms.entity.form-menu :route="route('admin.home')" :preview="false" :saveAndClose="false" />

      <div class="mb-3">
        <x-admin.forms.label for="name" :name="admin_trans('name')" :required="true" />
        <x-admin.forms.input id="name" name="name" :value="$user->name ?? null" :required="true" />
        <x-admin.forms.error name="name" />
      </div>

      <div class="mb-3">
        <x-admin.forms.label for="email" :name="admin_trans('email')" :required="true" />
        <x-admin.forms.input id="email" name="email" :value="$user->email ?? null" :required="true" />
        <x-admin.forms.error name="email" />
      </div>

    </form>
  </div>

  <div class="card mt-4">
    <h5 class="card-header">{{ admin_trans('delete_account') }}</h5>
    <div class="card-body">
      <div class="mb-3 col-12 mb-0">
        <div class="alert alert-warning">
          <h6 class="alert-heading fw-bold mb-1">{{ admin_trans('delete_account_warning') }}</h6>
          <p class="mb-0">{{ admin_trans('delete_account_warning_description') }}</p>
        </div>
      </div>
      <form id="formAccountDeactivation" action="{{ route('users.delete_acount', $user->id) }}" method="POST"
        novalidate>
        @csrf
        @method('DELETE')

        <div class="form-check mb-3">
          <input class="form-check-input" type="checkbox" name="account_activation" id="accountActivation">
          <label class="form-check-label" for="accountActivation">{{ admin_trans('confirm_account_deactivation') }}</label>
        </div>
        <button type="submit" class="btn btn-danger deactivate-account">{{ admin_trans('deactivate_account') }}</button>
      </form>
    </div>
  </div>

</x-admin-layout>