<x-admin-layout>
    <x-slot:horizontalNav>
        @include('partials.admin.layout._horizontal-nav')
    </x-slot:horizontalNav>

    <x-admin.page-heading :spanContent="admin_trans('headings.profile') . ' /'" :content="admin_trans('headings.password')" />

    <div id="recordForm" class="card">
        <form class="card-body" action="{{ route('user-password.update', $user->id) }}" method="POST" novalidate>
            @csrf
            @method('PUT')

            <x-admin.forms.entity.form-menu :route="route('admin.home')" :preview="false" :saveAndClose="false" />

            <div class="mb-3">
                <x-admin.forms.label for="current_password" name="current_password" :required="true" />
                <x-admin.forms.input id="current_password" type="password" name="current_password" :required="true" />
            </div>

            <div class="mb-3">
                <x-admin.forms.label for="password" name="password" :required="true" />
                <x-admin.forms.input id="password" type="password" name="password" :required="true" />
            </div>

            <div class="mb-3">
                <x-admin.forms.label for="password_confirmation" name="password_confirmation" :required="true" />
                <x-admin.forms.input id="password_confirmation" type="password" name="password_confirmation"
                    :required="true" />
            </div>

        </form>
        @if ($errors->updatePassword->any())
        <div class="alert alert-danger">
            @foreach($errors->updatePassword->all() as $error)
            <span class="d-block">{{ $error }}</span>
            @endforeach
        </div>
        @endif
    </div>

</x-admin-layout>