<div class="row">
	<div class="col-xl-9">
		<div class="nav-align-top mb-4">
			<x-admin.errors-all />

			<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
				@foreach($languages as $key => $language)
					<li class="nav-item">
						<button
							type="button"
							class="nav-link @if($key === 0) active @endif"
							role="tab"
							data-bs-toggle="tab"
							data-bs-target="#navs-menu-item-{{ $language->code }}{{ !empty($menuItem) ? '-' . $menuItem->id : null }}"
							aria-controls="navs-menu-item-{{ $language->code }}{{ !empty($menuItem) ? '-' . $menuItem->id : null }}"
							aria-selected="true"
						>
							{{ $language->name }}
						</button>
					</li>
				@endforeach
			</ul>

			<div class="tab-content">
				@foreach($languages as $key => $language)
				<div
					class="tab-pane fade show @if($key === 0) active @endif"
					id="navs-menu-item-{{ $language->code }}{{ !empty($menuItem) ? '-' . $menuItem->id : null }}"
					role="tabpanel"
				>
					<div class="mb-3">
						<x-admin.forms.label :for="'title-' . $language->id" :name="admin_trans('menu_items.title')" :required="true" />
						<x-admin.forms.input
							:id="'title-' . $language->id"
							:name="$language->locale . '[title]'"
							:value="!empty($menuItem) && !empty($menuItem->translate($language->locale)->title) ? $menuItem->translate($language->locale)->title : null"
							:required="true"
						/>
						<x-admin.forms.error :name="$language->locale . '.title'" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label :for="'link-' . $language->id" :name="admin_trans('menu_items.link')" :required="true" />
						<x-admin.forms.input
							:id="'link-' . $language->id"
							:name="$language->locale . '[link]'"
							:value="!empty($menuItem) && !empty($menuItem->translate($language->locale)->link) ? $menuItem->translate($language->locale)->link : null"
							:required="true"
						/>
						<x-admin.forms.error :name="$language->locale . '.link'" />
					</div>
				</div>
				@endforeach
			</div>
		</div>
	</div>

	<div class="col-xl-3 mt-5">
		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('option_panel')) }}</h5>
		</section>
	</div>
</div>