<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.menus') . ' /'" :content="$menu->title" />

	<div id="recordForm">
		<form action="{{ route('admin.settings.menus.update', $menu->id) }}" method="POST" novalidate>
			@csrf
			@method('PUT')

			<x-admin.forms.entity.form-menu :route="route('admin.settings.menus.index')" :preview="false" />

			@include('admin.settings.menus._form')
		</form>
	</div>

	<section class="my-1">
		<h2 class="h3 mb-3">{{ admin_trans('headings.menu_items') }}</h2>
		<a
			href="{{ route('admin.settings.menus.menu-items.create', ['menu' => $menu->id]) }}"
			type="button"
			class="btn btn-primary mb-1"
		>{{ admin_trans('btn_create') }}</a>

		@if (!empty($menuItems))
			<div class="dd" id="nestable" data-url="{{ route('admin.settings.menus.menu-items.sort') }}">
				<x-admin.nestable-list :records="$menuItems" recordName="menuItem" route="admin.settings.menus.menu-items" :hasActive="false" />
			</div>
		@endif
	</section>
</x-admin-layout>