<div class="row">
	<div class="col-xl-9">
		<div class="nav-align-top mb-4">
			<x-admin.errors-all />

			<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
				@foreach($languages as $key => $language)
					<li class="nav-item">
						<button
							type="button"
							class="nav-link @if($key === 0) active @endif"
							role="tab"
							data-bs-toggle="tab"
							data-bs-target="#navs-menu-{{ $language->code }}{{ !empty($menu) ? '-' . $menu->id : null }}"
							aria-controls="navs-menu-{{ $language->code }}{{ !empty($menu) ? '-' . $menu->id : null }}"
							aria-selected="true"
						>
							{{ $language->name }}
						</button>
					</li>
				@endforeach
			</ul>

			<div class="tab-content">
				@foreach($languages as $key => $language)
					<div
						class="tab-pane fade show @if($key === 0) active @endif"
						id="navs-menu-{{ $language->code }}{{ !empty($menu) ? '-' . $menu->id : null }}"
						role="tabpanel"
					>
						<div class="mb-3">
							<x-admin.forms.label :for="'title-' . $language->id" :name="admin_trans('menu.title')" :required="true" />
							<x-admin.forms.input
								:id="'title-' . $language->id"
								:name="$language->locale . '[title]'"
								:value="!empty($menu) && !empty($menu->translate($language->locale)->title) ? $menu->translate($language->locale)->title : null"
								:required="true"
							/>
							<x-admin.forms.error :name="$language->locale . '.title'" />
						</div>
					</div>
				@endforeach
			</div>
		</div>
	</div>

	<div class="col-xl-3 mt-5">
		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('option_panel')) }}</h5>
			<div class="card-body">
				<x-admin.forms.entity.form-switch name="is_active" :isRecordActive="$menu->is_active ?? false" />

				<div class="mt-4">
					<x-admin.forms.label for="type" :name="admin_trans('menu.type')" :required="false" />
					<select id="type" name="type" class="form-select" aria-label="Select type">
						<option value="">{{ admin_trans('menu.select') }}</option>
						@foreach ($menuTypes as $type)
							<option value="{{ $type->id }}" {{ old("type", $menu->type ?? 0) == $type->id ? 'selected' : '' }}>{{ admin_trans('menu.types.' . $type->name) }}</option>
						@endforeach
					</select>
					<x-admin.forms.error name="type" />
				</div>
			</div>
		</section>
	</div>
</div>