<div class="row">
	<div class="col-xl-9">
		<div class="nav-align-top mb-4">
			<x-admin.errors-all />

			<div class="card">
				<div class="card-body">
					<div class="mb-3">
						<x-admin.forms.label for="domain" :name="admin_trans('domain')" :required="true" />
						<x-admin.forms.input id="domain" name="domain" :value="!empty($domain) ? $domain->domain : null" :required="true" />
						<x-admin.forms.error name="domain" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="email" :name="admin_trans('email')" :required="false" />
						<x-admin.forms.input id="email" name="email" :value="!empty($domain) ? $domain->email : null" :required="false" />
						<x-admin.forms.error name="email" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="phone" :name="admin_trans('phone')" :required="false" />
						<x-admin.forms.input id="phone" name="phone" :value="!empty($domain) ? $domain->phone : null" :required="false" />
						<x-admin.forms.error name="phone" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="facebook" :name="admin_trans('facebook')" :required="false" />
						<x-admin.forms.input id="facebook" name="facebook" :value="!empty($domain) ? $domain->facebook : null" :required="false" />
						<x-admin.forms.error name="facebook" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="linkedin" :name="admin_trans('linkedin')" :required="false" />
						<x-admin.forms.input id="linkedin" name="linkedin" :value="!empty($domain) ? $domain->linkedin : null" :required="false" />
						<x-admin.forms.error name="linkedin" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="twitter" :name="admin_trans('twitter')" :required="false" />
						<x-admin.forms.input id="twitter" name="twitter" :value="!empty($domain) ? $domain->twitter : null" :required="false" />
						<x-admin.forms.error name="twitter" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="instagram" :name="admin_trans('instagram')" :required="false" />
						<x-admin.forms.input id="instagram" name="instagram" :value="!empty($domain) ? $domain->instagram : null" :required="false" />
						<x-admin.forms.error name="instagram" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="youtube" :name="admin_trans('youtube')" :required="false" />
						<x-admin.forms.input id="youtube" name="youtube" :value="!empty($domain) ? $domain->youtube : null" :required="false" />
						<x-admin.forms.error name="youtube" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="header_scripts" :name="admin_trans('header_scripts')" :required="false" />
						<x-admin.forms.textarea id="header_scripts" name="header_scripts" :value="!empty($domain) ? $domain->header_scripts : null" :required="false" rows="10" />
						<x-admin.forms.error name="header_scripts" />
					</div>

					<div class="mb-3">
						<x-admin.forms.label for="body_scripts" :name="admin_trans('body_scripts')" :required="false" />
						<x-admin.forms.textarea id="body_scripts" name="body_scripts" :value="!empty($domain) ? $domain->body_scripts : null" :required="false" rows="10" />
						<x-admin.forms.error name="body_scripts" />
					</div>
				</div>
			</div>
		</div>

		<div class="nav-align-top mb-4">
			<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
				@foreach($languages as $key => $language)
					<li class="nav-item">
						<button
							type="button"
							class="nav-link @if($key === 0) active @endif"
							role="tab"
							data-bs-toggle="tab"
							data-bs-target="#navs-privacy-policy-link-{{ $language->code }}{{ !empty($domain) ? '-' . $domain->id : null }}"
							aria-controls="navs-privacy-policy-link-{{ $language->code }}{{ !empty($domain) ? '-' . $domain->id : null }}"
							aria-selected="true"
						>
							{{ $language->name }}
						</button>
					</li>
				@endforeach
			</ul>

			<div class="tab-content">
				@foreach($languages as $key => $language)
				<div
					class="tab-pane fade show @if($key === 0) active @endif"
					id="navs-privacy-policy-link-{{ $language->code }}{{ !empty($domain) ? '-' . $domain->id : null }}"
					role="tabpanel"
				>
					<div class="mb-3">
						<x-admin.forms.label for="privacy_policy_link" :name="admin_trans('privacy_policy_link')" :required="false" />
						<x-admin.forms.input id="privacy_policy_link" name="privacy_policy_link" :value="!empty($domain) ? $domain->privacy_policy_link : null" :required="false" />
						<x-admin.forms.error name="privacy_policy_link" />
					</div>
				</div>
				@endforeach
			</div>
		</div>
	</div>

	<div class="col-xl-3">
		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('logo')) }}</h5>
			<div class="card-body">
				<x-admin.forms.label :for="'logo'" :name="admin_trans('logo')" :required="false" />

				<div class="coverImage text-center">
					@if (!empty($domain->logo))
						<img src="{{ asset('storage/' . $domain->logo) }}" width="100%" alt="Logo" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
					@else
						<img src="{{ asset('storage/admin/images/no_image.jpg') }}" width="100%" alt="No image">
					@endif
				</div>

				<div class="filePreview hidden">
					<label for="logo">Image Preview</label><br>
					<input type="hidden" class="cover_image" name="logo" value="{{ !empty($domain) ? $domain->logo : null }}">
					<img src="" alt="Logo">
				</div>

				<div class="parentCoverImgUploadBtn text-center mt-4">
					<button
						type="button"
						data-filemanagerroute="{{ route('elfinder.popup', 'cover_image') }}"
						data-inputid="logo"
						data-mimes="image"
						class="coverImgUploadBtn btn btn-icon btn-primary popup_selector"
					>
						<span class="tf-icons bx bx-image-add"></span>
					</button>

					@if (!empty($domain->logo))
						<button
							type="button"
							class="coverImgDeleteBtn btn btn-icon btn-danger"
							data-deletecoverimageroute="{{ route('admin.settings.domains.delete-logo', ['domain' => $domain, 'logoType' => 'logo']) }}"
						>
							<span class="tf-icons bx bx-trash"></span>
						</button>
					@endif
				</div>
				<x-admin.forms.error name="logo" />
			</div>
		</section>

		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('logo_mobile')) }}</h5>
			<div class="card-body">
				<x-admin.forms.label :for="'logo_mobile'" :name="admin_trans('logo_mobile')" :required="false" />

				<div class="coverImage text-center">
					@if (!empty($domain->logo_mobile))
						<img src="{{ asset('storage/' . $domain->logo_mobile) }}" width="100%" alt="Logo" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
					@else
						<img src="{{ asset('storage/admin/images/no_image.jpg') }}" width="100%" alt="No image">
					@endif
				</div>

				<div class="filePreview hidden">
					<label for="logo_mobile">Image Preview</label><br>
					<input type="hidden" class="cover_image" name="logo_mobile" value="{{ !empty($domain) ? $domain->logo_mobile : null }}">
					<img src="" alt="Logo">
				</div>

				<div class="parentCoverImgUploadBtn text-center mt-4">
					<button
						type="button"
						data-filemanagerroute="{{ route('elfinder.popup', 'cover_image') }}"
						data-inputid="logo_mobile"
						data-mimes="image"
						class="coverImgUploadBtn btn btn-icon btn-primary popup_selector"
					>
						<span class="tf-icons bx bx-image-add"></span>
					</button>

					@if (!empty($domain->logo))
						<button
							type="button"
							class="coverImgDeleteBtn btn btn-icon btn-danger"
							data-deletecoverimageroute="{{ route('admin.settings.domains.delete-logo', ['domain' => $domain, 'logoType' => 'logo_mobile']) }}"
						>
							<span class="tf-icons bx bx-trash"></span>
						</button>
					@endif
				</div>
				<x-admin.forms.error name="logo_mobile" />
			</div>
		</section>

		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('footer_logo')) }}</h5>
			<div class="card-body">
				<x-admin.forms.label :for="'footer_logo'" :name="admin_trans('footer_logo')" :required="false" />

				<div class="coverImage text-center">
					@if (!empty($domain->footer_logo))
						<img src="{{ asset('storage/' . $domain->footer_logo) }}" width="100%" alt="Logo" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
					@else
						<img src="{{ asset('storage/admin/images/no_image.jpg') }}" width="100%" alt="No image">
					@endif
				</div>

				<div class="filePreview hidden">
					<label for="footerLogo">Image Preview</label><br>
					<input type="hidden" class="cover_image" name="footer_logo" value="{{ !empty($domain) ? $domain->footer_logo : null }}">
					<img src="" alt="Logo">
				</div>

				<div class="parentCoverImgUploadBtn text-center mt-4">
					<button
						type="button"
						data-filemanagerroute="{{ route('elfinder.popup', 'cover_image') }}"
						data-inputid="footer_logo"
						data-mimes="image"
						class="coverImgUploadBtn btn btn-icon btn-primary popup_selector"
					>
						<span class="tf-icons bx bx-image-add"></span>
					</button>

					@if (!empty($domain->footer_logo))
						<button
							type="button"
							class="coverImgDeleteBtn btn btn-icon btn-danger"
							data-deletecoverimageroute="{{ route('admin.settings.domains.delete-logo', ['domain' => $domain, 'logoType' => 'footer_logo']) }}"
						>
							<span class="tf-icons bx bx-trash"></span>
						</button>
					@endif
				</div>
				<x-admin.forms.error name="footer_logo" />
			</div>
		</section>

		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('footer_logo_mobile')) }}</h5>
			<div class="card-body">
				<x-admin.forms.label :for="'footer_logo_mobile'" :name="admin_trans('footer_logo_mobile')" :required="false" />

				<div class="coverImage text-center">
					@if (!empty($domain->footer_logo_mobile))
						<img src="{{ asset('storage/' . $domain->footer_logo_mobile) }}" width="100%" alt="Logo" data-default-image="{{ asset('storage/admin/images/no_image.jpg') }}">
					@else
						<img src="{{ asset('storage/admin/images/no_image.jpg') }}" width="100%" alt="No image">
					@endif
				</div>

				<div class="filePreview hidden">
					<label for="footerLogoMobile">Image Preview</label><br>
					<input type="hidden" class="cover_image" name="footer_logo_mobile" value="{{ !empty($domain) ? $domain->footer_logo_mobile : null }}">
					<img src="" alt="Logo">
				</div>

				<div class="parentCoverImgUploadBtn text-center mt-4">
					<button
						type="button"
						data-filemanagerroute="{{ route('elfinder.popup', 'cover_image') }}"
						data-inputid="footer_logo_mobile"
						data-mimes="image"
						class="coverImgUploadBtn btn btn-icon btn-primary popup_selector"
					>
						<span class="tf-icons bx bx-image-add"></span>
					</button>

					@if (!empty($domain->footer_logo))
						<button
							type="button"
							class="coverImgDeleteBtn btn btn-icon btn-danger"
							data-deletecoverimageroute="{{ route('admin.settings.domains.delete-logo', ['domain' => $domain, 'logoType' => 'footer_logo_mobile']) }}"
						>
							<span class="tf-icons bx bx-trash"></span>
						</button>
					@endif
				</div>
				<x-admin.forms.error name="footer_logo_mobile" />
			</div>
		</section>
	</div>
</div>