<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.sections') . '/ '" :content="admin_trans('sections.select_type')" />

	<div id="breadcrumb" class="mb-4">
		<a href="{{ route('admin.home') }}">{{ admin_trans('home') }}</a> /
		<a href="{{ route('admin.' . $parent->getTable() . '.edit', $parent->id) }}">{{ admin_trans('headings.' . $parent::class) }}: {{ $parent->title }}</a> /
		<span>{{ admin_trans('sections.select_type') }}</span>
	</div>

	<div id="sectionTypeForm" data-route="{{ route('admin.sections.create') }}">
		<section>
			<div class="container-xxl flex-grow-1 p-0">
				<h3 class="">{{ admin_trans('sections.section_types') }}</h3>

				<div class="row mb-5">
					@foreach ($sectionTypes as $sectionType)
						<div
							class="sectionType col-md-3 col-lg-3 mb-4"
							data-sectiontype="{{ $sectionType->id }}"
							data-parentid="{{ $parent->id }}"
							data-parentclass="{{ $parent::class }}"
						>
							<div class="card h-100">
								<div class="card-body">
									<span class="card-title">{{ str()->of($sectionType->type)->title()->replace('_', ' ') }}</span><br>
								</div>
								<img src="{{ asset('storage/' . $sectionType->cover_image) }}" class="img-fluid" alt="{{ $sectionType->type }}">
							</div>
						</div>
					@endforeach
				</div>
			</div>
		</section>
	</div>
</x-admin-layout>