<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.section_elements') . '/ '" :content="admin_trans('section_elements.select_type')" />

	<div id="breadcrumb" class="mb-4">
		<a href="{{ route('admin.home') }}">{{ admin_trans('home') }}</a> /
		<a href="{{ route('admin.sections.edit', $section->id) }}">{{ admin_trans('headings.sections') }}: {{ $section->title }}</a> /
		<span>{{ admin_trans('section_elements.select_type') }}</span>
	</div>

	<div id="sectionElementTypeForm" data-route="{{ route('admin.section-elements.create') }}">
		<section>
			<div class="container-xxl flex-grow-1 p-0">
				<h3 class="">{{ admin_trans('section_elements.section_element_types') }}</h3>

				<div class="row mb-5">
					@foreach ($sectionElementTypes as $sectionElementType)
						<div
							class="sectionElementType col-md-3 col-lg-3 mb-4"
							data-sectionelementtype="{{ $sectionElementType->id }}"
							data-sectionid="{{ $section->id }}"
						>
							<div class="card h-100">
								<div class="card-body">
									<span class="card-title">{{ $sectionElementType->type }}</span><br>
								</div>
								<img src="{{ asset('storage/' . $sectionElementType->cover_image) }}" class="img-fluid" alt="{{ $sectionElementType->type }}">
							</div>
						</div>
					@endforeach
				</div>
			</div>
		</section>
	</div>
</x-admin-layout>