<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.section_elements') . ' /'" :content="Str::of($sectionElement->sectElType->type)->title()->replace('_', ' ') . ': ' . $sectionElement->admin_title" />

	<div id="breadcrumb" class="mb-4">
		<a href="{{ route('admin.home') }}">{{ admin_trans('home') }}</a> /
		<a href="{{ route('admin.sections.edit', $sectionElement->section->id) }}">{{ admin_trans('headings.sections') }}: {{ $sectionElement->section->title }}</a> /
		<span>{{ admin_trans('section_elements.base_type') }}: {{ $sectionElement->admin_title }}</span>
	</div>

	<div id="recordForm">
		<form action="{{ route('admin.section-elements.update', $sectionElement->id) }}" method="POST" novalidate>
			@csrf
			@method('PUT')

			<x-admin.forms.entity.form-menu :route="route('admin.sections.edit', $sectionElement->section->id)" :preview="false" :saveAndClose="true" />

			@include('admin.sections.elements._form')
		</form>
	</div>

</x-admin-layout>
