<x-admin-layout>
	<x-slot:horizontalNav>
		@include('partials.admin.layout._horizontal-nav')
	</x-slot:horizontalNav>

	<x-admin.page-heading :spanContent="admin_trans('headings.section_elements') . '/ '" :content="admin_trans('section_elements.new')" />

	<div id="breadcrumb" class="mb-4">
		<a href="{{ route('admin.home') }}">{{ admin_trans('home') }}</a> /
		<a href="{{ route('admin.sections.edit', $section->id) }}">{{ admin_trans('headings.sections') }}: {{ $section->title }}</a> /
		<span>{{ admin_trans('section_elements.new') }}: {{ Str::of($sectionElementType->type)->replace('_', ' ')->title() }}</span>
	</div>

	<div id="recordForm">
		<form action="{{ route('admin.section-elements.store') }}" method="POST" novalidate>
			@csrf

			<x-admin.forms.entity.form-menu :route="route('admin.sections.edit', $section)" :preview="false" :saveAndClose="false" />

			<div class="row">
				<div class="col-xl-9">
					<input type="hidden" name="section_id" value="{{ $section->id }}">
					<input type="hidden" name="sect_el_type_id" value="{{ $sectionElementType->id }}">

					<div class="nav-align-top mb-4">
						<x-admin.errors-all />

						<div class="mb-3">
							<x-admin.forms.label for="admin_title" :name="admin_trans('admin_title')" required="true" />
							<x-admin.forms.input id="admin_title" name="admin_title" required="true" />
							<x-admin.forms.error name="admin_title" />
						</div>

						<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
							@foreach($languages as $key => $language)
							<li class="nav-item">
								<button
									type="button"
									class="nav-link @if($key === 0) active @endif"
									role="tab"
									data-bs-toggle="tab"
									data-bs-target="#navs-section-element-top-{{ $language->code }}{{ !empty($sectionElement) ? '-' . $sectionElement->id : null }}"
									aria-controls="navs-section-element-top-{{ $language->code }}{{ !empty($sectionElement) ? '-' . $sectionElement->id : null }}"
									aria-selected="true"
								>
									{{$language->name}}
								</button>
							</li>
							@endforeach
						</ul>

						<div class="tab-content">
							@foreach($languages as $key => $language)
							<div
								class="tab-pane fade show @if($key === 0) active @endif"
								id="navs-section-element-top-{{ $language->code }}{{ !empty($sectionElement) ? '-' . $sectionElement->id : null }}"
								role="tabpanel"
							>
								@forelse($sectionElementType->fields as $field)
									@if ($field->isString())
										<div class="mb-3">
											<x-admin.forms.label :for="$field->name . '-' . $language->id" :name="$field->name" :required="true" />
											<x-admin.forms.input :id="$field->name . '-' . $language->id" :name="'fields[' . $language->locale . '][' . $field->name . ']'" :required="true" />
											<x-admin.forms.error :name="$language->locale . '.' . $field->name" />
										</div>
									@endif

									@if ($field->isText())
										<div class="mb-3">
											<x-admin.forms.label :for="$field->name . '-' . $language->id" :name="$field->name" :required="true" />
											<x-admin.forms.textarea :id="$field->name . '-' . $language->id" :name="'fields[' . $language->locale . '][' . $field->name . ']'" :required="true" />
											<x-admin.forms.error :name="$language->locale . '.' . $field->name" />
										</div>
									@endif

									@if ($field->isImage())
										@include('admin.sections.elements._form-partials._image')
									@endif

								@empty
									<div class="alert alert-info">
										{{ admin_trans('section_elements.no_fields') }}
									</div>
								@endforelse

							</div>
							@endforeach
						</div>
					</div>
				</div>

				<div class="col-xl-3 mt-5">
					<section class="card mb-4">
						<h5 class="card-header">{{ str()->title(admin_trans('option_panel')) }}</h5>
						<div class="card-body">
							<x-admin.forms.entity.form-switch name="is_active" :isRecordActive="$sectionElement->is_active ?? false" />
						</div>
					</section>

					<x-admin.forms.cover-image :entity="$sectionElement ?? null" coverImageDeleteRoute="admin.section-elements.delete-cover-image" />
				</div>
			</div>
		</form>
	</div>
</x-admin-layout>