<input
	type="hidden"
	name="section_id"
	value="{{ !empty($sectionElement) ? $sectionElement->section->id : (!empty($section) ? $section->id : null) }}"
>
<input type="hidden" name="sect_el_type_id" value="@isset($sectionElementType) {{ $sectionElementType->id }} @endisset">

<div class="row">
	<div class="col-xl-9">
		<div class="nav-align-top mb-4">
			<x-admin.errors-all />

			<div class="mb-3">
				<x-admin.forms.label for="admin_title" :name="admin_trans('admin_title')" required="true" />
				<x-admin.forms.input id="admin_title" name="admin_title" :value="!empty($sectionElement) ? $sectionElement->admin_title : null" required="true" />
				<x-admin.forms.error name="admin_title" />
			</div>

			<ul id="language-tabs" class="nav nav-pills mb-2" role="tablist">
				@foreach($languages as $key => $language)
				<li class="nav-item">
					<button
						type="button"
						class="nav-link @if($key === 0) active @endif"
						role="tab"
						data-bs-toggle="tab"
						data-bs-target="#navs-section-top-{{ $language->code }}{{ !empty($sectionElement) ? '-' . $sectionElement->id : null }}"
						aria-controls="navs-section-top-{{ $language->code }}{{ !empty($sectionElement) ? '-' . $sectionElement->id : null }}"
						aria-selected="true"
					>
						{{ $language->name }}
					</button>
				</li>
				@endforeach
			</ul>

			<div class="tab-content">
				@foreach($languages as $key => $language)
					<div
						class="tab-pane fade show @if($key === 0) active @endif"
						id="navs-section-top-{{ $language->code }}{{ !empty($sectionElement) ? '-' . $sectionElement->id : null }}"
						role="tabpanel"
					>
						@forelse($sectionElementType->fields as $field)
							@if ($field->isString())
								@include('admin.sections.elements._form-partials._string')
							@endif

							@if ($field->isInteger())
								@include('admin.sections.elements._form-partials._integer')
							@endif

							@if ($field->isText())
								@include('admin.sections.elements._form-partials._text')
							@endif

							@if ($field->isImage())
								@include('admin.sections.elements._form-partials._image')
							@endif

						@empty
							<div class="alert alert-info">
								{{ admin_trans('section_elements.no_fields') }}
							</div>
						@endforelse
					</div>
				@endforeach
			</div>
		</div>
	</div>

	<div class="col-xl-3 mt-5">
		<section class="card mb-4">
			<h5 class="card-header">{{ str()->title(admin_trans('option_panel')) }}</h5>

			<div class="card-body">
				<x-admin.forms.entity.form-switch name="is_active" :isRecordActive="$sectionElement->is_active ?? false" />
			</div>
		</section>

		<x-admin.forms.cover-image :entity="$sectionElement ?? null" coverImageDeleteRoute="admin.section-elements.delete-cover-image" />
	</div>
</div>